-- Interop file for Ashfall made as per https://github.com/jhaakma/ashfall/wiki/Interoperability

if not tes3.isModActive("Tamriel_Data.esm") then return end

event.register(tes3.event.initialized, function()
	local ashfall = include("mer.ashfall.interop")
	if ashfall then
		
		local types = {
			-- Types of activators
			tree = "tree",
			wood = "wood",
			vegetation = "vegetation",
			stump = "stump",
			deadTree = "deadTree",
			waterClean = "waterClean",
			waterDirty = "waterDirty",
			keg = "keg",
			well = "well",
			stoneSource = "stoneSource",

			-- Types of consumables
			food = "food",
			meat = "meat",
			vegetable = "vegetable",
			cookedMeat = "cookedMeat",
			herb = "herb",
			mushroom = "mushroom",
			egg = "egg",
			seasoning = "seasoning",

			-- Types of water containers
			cup = "cup",
			glass = "glass",
			goblet = "goblet",
			mug = "mug",
			tankard = "tankard",
			flask = "flask",
			bottle = "bottle",
			pot = "pot",
			jug = "jug",
			pitcher = "pitcher",

			-- Region climates
			polar = 'polar',
			cold = 'cold',
			mild = 'mild',
			temperate = 'temperate',
			tropical = 'tropical',
			dry = 'dry',
			volcanic = 'volcanic',
			scorching = { min = -40, max = 25 },	-- Just using the dry climate like the Colovian Highlands wouldn't do justice for the regions that make up the Alik'r desert 
		}

		ashfall.registerActivators{

		    -- Water: Clean
			t_com_var_barrelwater_01    = types.waterClean,
			t_glb_terrwater_waterjet_01 = types.waterClean,

			-- Water: Dirty
			t_bre_furn_bathhalfbarrel_01    = types.waterDirty,
			t_com_furn_bath_01              = types.waterDirty,
			t_com_furn_bathhalfbarrel_01    = types.waterDirty,
			t_com_furn_bathhalfbarrel_02    = types.waterDirty,
			t_com_set_waterwheel_01         = types.waterDirty,
			t_glb_terrwater_circle1024_01   = types.waterDirty,
			t_glb_terrwater_circle128_01    = types.waterDirty,
			t_glb_terrwater_circle2048_01   = types.waterDirty,
			t_glb_terrwater_circle256_01    = types.waterDirty,
			t_glb_terrwater_circle512_01    = types.waterDirty,
			t_glb_terrwater_circle64_01     = types.waterDirty,
			t_glb_terrwater_curveflw256_01  = types.waterDirty,
			t_glb_terrwater_curveflw256s_01 = types.waterDirty,
			t_glb_terrwater_curveflw512_01  = types.waterDirty,
			t_glb_terrwater_curveflw512s_01 = types.waterDirty,
			t_glb_terrwater_curverpd256_01  = types.waterDirty,
			t_glb_terrwater_curverpd256s_01 = types.waterDirty,
			t_glb_terrwater_curverpd512_01  = types.waterDirty,
			t_glb_terrwater_curverpd512s_01 = types.waterDirty,
			t_glb_terrwater_rectflw256_01   = types.waterDirty,
			t_glb_terrwater_rectflw256_02   = types.waterDirty,
			t_glb_terrwater_rectflw256_03   = types.waterDirty,
			t_glb_terrwater_rectrpd256_01   = types.waterDirty,
			t_glb_terrwater_rectrpd256_02   = types.waterDirty,
			t_glb_terrwater_rectrpd256_03   = types.waterDirty,
			t_glb_terrwater_rectstill256_01 = types.waterDirty,
			t_glb_terrwater_rectstill256_02 = types.waterDirty,
			t_glb_terrwater_rectstill256_03 = types.waterDirty,
			t_glb_terrwater_sqrflw1024_01   = types.waterDirty,
			t_glb_terrwater_sqrflw256_01    = types.waterDirty,
			t_glb_terrwater_sqrflw512_01    = types.waterDirty,
			t_glb_terrwater_sqrstill1024_01 = types.waterDirty,
			t_glb_terrwater_sqrstill256_01  = types.waterDirty,
			t_glb_terrwater_sqrstill512_01  = types.waterDirty,
			t_glb_terrwatersew_waterfall_01 = types.waterDirty,
			t_glb_terrwatersew_waterfall_02 = types.waterDirty,
			t_glb_terrwatersew_waterfall_03 = types.waterDirty,
			t_de_sethla_x_watercbnarsis_01  = types.waterDirty,
			t_de_sethla_x_waternarsis_01    = types.waterDirty,
			t_de_sethla_x_waternarsis_0     = types.waterDirty,
			t_de_sethla_x_waternarsis_03    = types.waterDirty,
			t_imp_furn_bath_01_w            = types.waterDirty,
			t_imp_furnr_bath_01             = types.waterDirty,
			t_imp_furnr_bath_02_w           = types.waterDirty,

			-- Water: Kegs
			t_bre_furn_kegstand_01  = types.keg,
			t_nor_furnm_kegstand_01 = types.keg,

			-- Water: Wells
			  -- High Rock
			t_bre_setostr_x_well_01   = types.well,
			t_bre_setostr_x_well_02   = types.well,
			  -- Morrowind
			t_com_set_well_02         = types.well,
			t_com_set_welldg_01       = types.well,
			t_de_sethla_x_well_01     = types.well,
			t_de_setind_x_well_01     = types.well,
			t_de_setmh_x_well_01      = types.well,
			t_de_setred_x_well_01     = types.well,
			t_de_setred_x_well_02     = types.well,
			t_de_setveloth_x_well_01  = types.well,
			t_dwe_dngruin_f_well_01   = types.well,
			  -- Cyrodiil
			t_ayl_dngruin_x_well_01   = types.well,
			t_imp_legioncyr_x_well_01 = types.well,
			t_imp_legioncyr_x_well_02 = types.well,
			t_imp_legionmw_x_well_01  = types.well,
			t_imp_legionmw_x_well_02  = types.well,
			t_imp_legionsky_x_well_01 = types.well,
			t_imp_legionsky_x_well_02 = types.well,
			t_imp_setgcpoor_x_well_01 = types.well,
			t_imp_setnord_x_well_01   = types.well,
			t_imp_setsky_x_well_01    = types.well,
			t_imp_setsky_x_well_02    = types.well,
			t_imp_setsky_x_well_03    = types.well,
			  -- Skyrim
			t_nor_set_well_01         = types.well,
			t_nor_set_well_02         = types.well,
			t_nor_set_well_03         = types.well,
			t_nor_set_well_04         = types.well,
			t_nor_set_well_05         = types.well,
			T_Nor_SetSkaal_Well_01    = types.well,
			  -- Hammerfell
			t_rga_setreach_x_pool_01  = types.well,

			-- Vegetation
			  -- Cyrodiil
			t_cyr_flora_alkanet01          = types.vegetation,
			t_cyr_flora_aloevera01         = types.vegetation,
			t_cyr_flora_aloevera02         = types.vegetation,
			t_cyr_flora_aloevera03         = types.vegetation,
			t_cyr_flora_aquilegia01        = types.vegetation,
			t_cyr_flora_bloodlill01        = types.vegetation,
			t_cyr_flora_bogbeac01          = types.vegetation,
			t_cyr_flora_bogbeac02          = types.vegetation,
			t_cyr_flora_bogbeac03          = types.vegetation,
			t_cyr_flora_chokeberr01        = types.vegetation,
			t_cyr_flora_cinnapoly01        = types.vegetation,
			t_cyr_flora_cinnapoly02        = types.vegetation,
			t_cyr_flora_cloudedfn01        = types.vegetation,
			t_cyr_flora_cloudedfn02        = types.vegetation,
			t_cyr_flora_cloudedfn03        = types.vegetation,
			t_cyr_flora_ginseng01          = types.vegetation,
			t_cyr_flora_ginseng02          = types.vegetation,
			t_cyr_flora_goldenrod01        = types.vegetation,
			t_cyr_flora_goldenrod02        = types.vegetation,
			t_cyr_flora_goldenrod03        = types.vegetation,
			t_cyr_flora_grape01            = types.vegetation,
			t_cyr_flora_grape02            = types.vegetation,
			t_cyr_flora_grape03            = types.vegetation,
			t_cyr_flora_greenstcp01        = types.vegetation,
			t_cyr_flora_greenstsh01        = types.vegetation,
			t_cyr_flora_indureta01         = types.vegetation,
			t_cyr_flora_inkwood01          = types.vegetation,
			t_cyr_flora_inkwood02          = types.vegetation,
			t_cyr_flora_inkwood03          = types.vegetation,
			t_cyr_flora_inkwood04          = types.vegetation,
			t_cyr_flora_ironrye01          = types.vegetation,
			t_cyr_flora_ironrye02          = types.vegetation,
			t_cyr_flora_ladysmck01         = types.vegetation,
			t_cyr_flora_ladysmnt01         = types.vegetation,
			t_cyr_flora_lillyvall01        = types.vegetation,
			t_cyr_flora_lillyvall02        = types.vegetation,
			t_cyr_flora_lillyvall03        = types.vegetation,
			t_cyr_flora_lillyvall04        = types.vegetation,
			t_cyr_flora_lotus01            = types.vegetation,
			t_cyr_flora_lycovine01         = types.vegetation,
			t_cyr_flora_mandrake01         = types.vegetation,
			t_cyr_flora_marasbead01        = types.vegetation,
			t_cyr_flora_marshstlk01        = types.vegetation,
			t_cyr_flora_monarda01          = types.vegetation,
			t_cyr_flora_monkshood01        = types.vegetation,
			t_cyr_flora_morningGl01        = types.vegetation,
			t_cyr_flora_morningGl02        = types.vegetation,
			t_cyr_flora_morningGl03        = types.vegetation,
			t_cyr_flora_motherw01          = types.vegetation,
			t_cyr_flora_peony01            = types.vegetation,
			t_cyr_flora_peony02            = types.vegetation,
			t_cyr_flora_pitcher_01         = types.vegetation,
			t_cyr_flora_pitcher_02         = types.vegetation,
			t_cyr_flora_poisonlil01        = types.vegetation,
			t_cyr_flora_poisonlil02        = types.vegetation,
			t_cyr_flora_poppad01           = types.vegetation,
			t_cyr_flora_primrose01         = types.vegetation,
			t_cyr_flora_primrose02         = types.vegetation,
			t_cyr_flora_primrose03         = types.vegetation,
			t_cyr_flora_siyat01            = types.vegetation,
			t_cyr_flora_socrata01          = types.vegetation,
			t_cyr_flora_socrata02          = types.vegetation,
			t_cyr_flora_socrata03          = types.vegetation,
			t_cyr_flora_spikerice01        = types.vegetation,
			t_cyr_flora_spikerice02        = types.vegetation,
			t_cyr_flora_spikerice03        = types.vegetation,
			t_cyr_flora_steelblue01        = types.vegetation,
			t_cyr_flora_steelblue02        = types.vegetation,
			t_cyr_flora_stinkhorn01        = types.vegetation,
			t_cyr_flora_stinkhorn02        = types.vegetation,
			t_cyr_flora_stjahnsWr01        = types.vegetation,
			t_cyr_flora_summerBol01        = types.vegetation,
			t_cyr_flora_summerBol02        = types.vegetation,
			t_cyr_flora_tacca01            = types.vegetation,
			t_cyr_flora_tacca02            = types.vegetation,
			t_cyr_flora_thunglew01         = types.vegetation,
			t_cyr_flora_tigerlill01        = types.vegetation,
			t_cyr_flora_tigerlill02        = types.vegetation,
			t_cyr_florach_shrub_01         = types.vegetation,
			t_cyr_florach_shrub_02         = types.vegetation,
			t_cyr_florach_shrub_03         = types.vegetation,
			t_cyr_florach_shrub_04         = types.vegetation,
			t_cyr_florach_shrub_05         = types.vegetation,
			t_cyr_florach_shrub_06         = types.vegetation,
			t_cyr_florach_shrub_07         = types.vegetation,
			t_cyr_florach_treebush_01      = types.vegetation,
			t_cyr_florach_treebush_02      = types.vegetation,
			t_cyr_florach_treebush_03      = types.vegetation,
			t_cyr_florach_treebush_04      = types.vegetation,
			t_cyr_florach_treebush_05      = types.vegetation,
			t_cyr_florach_treeshrub_01     = types.vegetation,
			t_cyr_florach_treeshrub_02     = types.vegetation,
			t_cyr_florach_treeshrub_03     = types.vegetation,
			t_cyr_florach_treeshrub_04     = types.vegetation,
			t_cyr_floragc_bush_01          = types.vegetation,
			t_cyr_floragc_bush_02          = types.vegetation,
			t_cyr_floragc_shrub_01         = types.vegetation,
			t_cyr_floragc_shrub_02         = types.vegetation,
			t_cyr_florastr_bush_01         = types.vegetation,
			t_cyr_florastr_shrub_01        = types.vegetation,
			t_cyr_flora_trinitypl01        = types.vegetation,
			t_cyr_flora_viperbugl01        = types.vegetation,
			t_cyr_flora_wheat01            = types.vegetation,
			t_cyr_flora_wheat02            = types.vegetation,
			t_cyr_flora_wheat03            = types.vegetation,
			t_cyr_flora_wispstalk01        = types.vegetation,
			t_cyr_flora_wispstalk02        = types.vegetation,
			t_cyr_flora_wispstalk03        = types.vegetation,
			t_cyr_flora_wispstalk04        = types.vegetation,
			t_cyr_flora_wispstalk05        = types.vegetation,
			t_cyr_florakp_bush_01          = types.vegetation,
			t_cyr_florakp_fern_01          = types.vegetation,
			t_cyr_florakp_fern_02          = types.vegetation,
			t_cyr_florakp_fern_03          = types.vegetation,
			t_cyr_florakp_fern_04          = types.vegetation,
			t_cyr_florakp_grass1_01        = types.vegetation,
			t_cyr_florakp_grass1_02        = types.vegetation,
			t_cyr_florakp_grass1_03        = types.vegetation,
			t_cyr_florakp_grass2_01        = types.vegetation,
			t_cyr_florakp_grass2_02        = types.vegetation,
			t_cyr_florakp_shrub_01         = types.vegetation,
			t_cyr_florakp_shrub_02         = types.vegetation,
			t_cyr_florakp_shrub_03         = types.vegetation,
			t_cyr_florakp_shrub_04         = types.vegetation,
			t_cyr_florakp_shrubgrass_01    = types.vegetation,
			t_cyr_florakp_shrubgrass_02    = types.vegetation,
			t_cyr_florakp_shrubgrass_03    = types.vegetation,
			t_cyr_florakp_shrubgrass_04    = types.vegetation,
			t_cyr_florakp_shrubgrass_05    = types.vegetation,
			t_cyr_florakp_shrubgrass_06    = types.vegetation,
			t_cyr_flora_elephantgrass_01   = types.vegetation,
			t_cyr_flora_elephantgrass_02   = types.vegetation,
			t_cyr_flora_elephantgrass_03   = types.vegetation,
			t_cyr_flora_elephantgrass_04   = types.vegetation,
			t_cyr_flora_elephantgrass_05   = types.vegetation,
			t_cyr_flora_elephantgrassgrp_01 = types.vegetation,
			t_cyr_flora_elephantgrassgrp_02 = types.vegetation,
			  -- Hammerfell
			t_ham_florarl_cactus_01        = types.vegetation,
			t_ham_florarl_cactus_02        = types.vegetation,
			t_ham_florarl_cactus_03        = types.vegetation,
			t_ham_florarl_pillarcactus_01  = types.vegetation,
			t_ham_florarl_pillarcactus_02  = types.vegetation,
			t_ham_florarl_pillarcactus_03  = types.vegetation,
			t_ham_florarl_pillarcactus_04  = types.vegetation,
			t_ham_florarl_pillarcactus_05  = types.vegetation,
			t_ham_florarl_pillarcactus_06  = types.vegetation,
			t_ham_florarl_pillarcactus_07  = types.vegetation,
			t_ham_florarl_shrub_01         = types.vegetation,
			t_ham_florarl_shrub_02         = types.vegetation,
			t_hr_flora_bitterstar01        = types.vegetation,
			t_hr_flora_bitterstar02        = types.vegetation,
			t_hr_flora_bjoulsrose01        = types.vegetation,
			t_hr_flora_bjoulsrose02        = types.vegetation,
			t_hr_flora_bleakstar_01        = types.vegetation,
			t_hr_flora_bleakstar_02        = types.vegetation,
			t_hr_flora_cornflo01           = types.vegetation,
			t_hr_flora_dragynia01          = types.vegetation,
			t_hr_flora_dragynia02          = types.vegetation,
			t_hr_flora_mistletoe01         = types.vegetation,
			t_hr_flora_redpoppy01          = types.vegetation,
			t_hr_flora_shadowfly01         = types.vegetation,
			t_hr_flora_shadowfly02         = types.vegetation,
			t_hr_flora_shadowfly03         = types.vegetation,
			t_hr_flora_shadowfly04         = types.vegetation,
			t_hr_flora_shadowfly05         = types.vegetation,
			t_hr_flora_shadowfly06         = types.vegetation,
			t_hr_flora_snowblossom1        = types.vegetation,
			t_hr_flora_wormwh01            = types.vegetation,
			t_hr_flora_wormwh02            = types.vegetation,
			t_hr_flora_wormwh03            = types.vegetation,
			t_hr_flora_wrothggrap01        = types.vegetation,
			  -- Morrowind
			t_mw_flora_red_lily_01         = types.vegetation,
			t_mw_flora_thornelowan         = types.vegetation,
			t_mw_floraaj_shrub_01          = types.vegetation,
			t_mw_floraat_spartiumbealei_01 = types.vegetation,
			t_mw_floraat_spartiumbealei_02 = types.vegetation,
			t_mw_floraat_spartiumbealei_03 = types.vegetation,
			t_mw_floracm_fern01            = types.vegetation,
			t_mw_floracm_maiden01          = types.vegetation,
			t_mw_floracm_maiden02          = types.vegetation,
			t_mw_florads_saltgrass_01      = types.vegetation,
			t_mw_florads_saltgrass_02      = types.vegetation,
			t_mw_florads_saltgrass_03      = types.vegetation,
			t_mw_florads_saltgrass_04      = types.vegetation,
			t_mw_florads_saltgrass_05      = types.vegetation,
			t_mw_florads_saltgrass_06      = types.vegetation,
			t_mw_florads_saltgrass_07      = types.vegetation,
			t_mw_florads_saltgrass_08      = types.vegetation,
			t_mw_florads_saltstrapjuve_01  = types.vegetation,
			t_mw_florads_saltstrapjuve_02  = types.vegetation,
			t_mw_florads_saltstrapleaf_01  = types.vegetation,
			t_mw_florads_saltstrapleaf_02  = types.vegetation,
			t_mw_florads_saltstrapleaf_03  = types.vegetation,
			t_mw_florads_saltstrapleaf_04  = types.vegetation,
			t_mw_florads_saltstrapleaf_05  = types.vegetation,
			t_mw_florads_saltstrapleaf_06  = types.vegetation,
			t_mw_florads_saltstrapleaf_07  = types.vegetation,
			t_mw_florads_saltstrapleaf_08  = types.vegetation,
			t_mw_florads_saltstrapleaf_09  = types.vegetation,
			t_mw_florads_saltstrapleaf_10  = types.vegetation,
			t_mw_florads_silverstalk_01    = types.vegetation,
			t_mw_florads_silverstalk_02    = types.vegetation,
			t_mw_floramf_palm_01           = types.vegetation,
			t_mw_floramf_palm_02           = types.vegetation,
			t_mw_floramf_palm_03           = types.vegetation,
			t_mw_floramf_palm_04           = types.vegetation,
			t_mw_floramf_palm_05           = types.vegetation,
			t_mw_florash_bush_01           = types.vegetation,
			t_mw_florash_bush_02           = types.vegetation,
			t_mw_florash_bush_03           = types.vegetation,
			t_mw_florash_bush_04           = types.vegetation,
			t_mw_florash_bush_05           = types.vegetation,
			t_mw_florash_bush_06           = types.vegetation,
			t_mw_florash_bush_07           = types.vegetation,
			t_mw_florash_bush_08a          = types.vegetation,
			t_mw_florash_bush_08b          = types.vegetation,
			t_mw_florash_bush_08c          = types.vegetation,
			t_mw_florash_bush_09a          = types.vegetation,
			t_mw_florash_bush_09b          = types.vegetation,
			t_mw_florash_bush_09c          = types.vegetation,
			t_mw_florash_bush_10a          = types.vegetation,
			t_mw_florash_bush_10b          = types.vegetation,
			t_mw_florash_bush_10c          = types.vegetation,
			t_mw_florash_bush_11a          = types.vegetation,
			t_mw_florash_bush_11b          = types.vegetation,
			t_mw_florash_bush_11c          = types.vegetation,
			t_mw_florash_bush_12a          = types.vegetation,
			t_mw_florash_bush_12b          = types.vegetation,
			t_mw_florash_bush_12c          = types.vegetation,
			t_mw_florash_bush_13a          = types.vegetation,
			t_mw_florash_bush_13b          = types.vegetation,
			t_mw_florash_bush_13c          = types.vegetation,
			t_mw_floratv_grass_01          = types.vegetation,
			t_mw_floratv_grass_02          = types.vegetation,
			t_mw_floratv_grass_03          = types.vegetation,
			t_mw_floratv_treezifa_01       = types.vegetation,
			t_mw_floratv_treezifa_02       = types.vegetation,
			t_mw_floratv_treezifa_03       = types.vegetation,
			t_mw_floratv_treezifa_04       = types.vegetation,
			t_mw_floratv_treezifa_05       = types.vegetation,
			  -- Skyrim
			t_sky_flora_aspyrtea01         = types.vegetation,
			t_sky_flora_aspyrtea02         = types.vegetation,
			t_sky_flora_aspyrteah01        = types.vegetation,
			t_sky_flora_bearclaw01         = types.vegetation,
			t_sky_flora_bearclaw02         = types.vegetation,
			t_sky_flora_bksporecp01        = types.vegetation,
			t_sky_flora_bksporecp02        = types.vegetation,
			t_sky_flora_bksporecp03        = types.vegetation,
			t_sky_flora_bleakblh01         = types.vegetation,
			t_sky_flora_bleakblh02         = types.vegetation,
			t_sky_flora_bleakblh03         = types.vegetation,
			t_sky_flora_bleakblh04         = types.vegetation,
			t_sky_flora_blknet01           = types.vegetation,
			t_sky_flora_blknet02           = types.vegetation,
			t_sky_flora_blknetd01          = types.vegetation,
			t_sky_flora_blknetd02          = types.vegetation,
			t_sky_flora_bottomwee01        = types.vegetation,
			t_sky_flora_brideth01          = types.vegetation,
			t_sky_flora_brideth02          = types.vegetation,
			t_sky_flora_brideth03          = types.vegetation,
			t_sky_flora_bridethsn01        = types.vegetation,
			t_sky_flora_bridethsn02        = types.vegetation,
			t_sky_flora_bridethsn03        = types.vegetation,
			t_sky_flora_bushpine2_01       = types.vegetation,
			t_sky_flora_canisr01           = types.vegetation,
			t_sky_flora_carlineth01        = types.vegetation,
			t_sky_flora_cloudycrn01        = types.vegetation,
			t_sky_flora_cloudycrn02        = types.vegetation,
			t_sky_flora_cloudycrn03        = types.vegetation,
			t_sky_flora_comatus01          = types.vegetation,
			t_sky_flora_cowbell01          = types.vegetation,
			t_sky_flora_darksage01         = types.vegetation,
			t_sky_flora_darksaged01        = types.vegetation,
			t_sky_flora_deathbell01        = types.vegetation,
			t_sky_flora_forsythtr01        = types.vegetation,
			t_sky_flora_fungalpod01        = types.vegetation,
			t_sky_flora_grass1_01          = types.vegetation,
			t_sky_flora_grass1_02          = types.vegetation,
			t_sky_flora_grass1_03          = types.vegetation,
			t_sky_flora_grass2_01          = types.vegetation,
			t_sky_flora_grass2_02          = types.vegetation,
			t_sky_flora_grass2_03          = types.vegetation,
			t_sky_flora_grass3_01          = types.vegetation,
			t_sky_flora_grass3_02          = types.vegetation,
			t_sky_flora_grass3_03          = types.vegetation,
			t_sky_flora_grass4_01          = types.vegetation,
			t_sky_flora_grass5_01          = types.vegetation,
			t_sky_flora_grasscoast_01      = types.vegetation,
			t_sky_flora_grasscoast_02      = types.vegetation,
			t_sky_flora_grasscoast_03      = types.vegetation,
			t_sky_flora_grasscoast_04      = types.vegetation,
			t_sky_flora_grassdry1_01       = types.vegetation,
			t_sky_flora_grassdry1_02       = types.vegetation,
			t_sky_flora_grassdry1_03       = types.vegetation,
			t_sky_flora_grassfern1_01      = types.vegetation,
			t_sky_flora_grasspod01         = types.vegetation,
			t_sky_flora_grasspod02         = types.vegetation,
			t_sky_flora_grassshrub1_01     = types.vegetation,
			t_sky_flora_grassshrub1_02     = types.vegetation,
			t_sky_flora_grassshrub2_01     = types.vegetation,
			t_sky_flora_grassshrub2_02     = types.vegetation,
			t_sky_flora_grassshrub3_01     = types.vegetation,
			t_sky_flora_grassshrub3_02     = types.vegetation,
			t_sky_flora_grassshrub3_03     = types.vegetation,
			t_sky_flora_grassshrub4_01     = types.vegetation,
			t_sky_flora_grassshrub4_02     = types.vegetation,
			t_sky_flora_grassshrub5_01     = types.vegetation,
			t_sky_flora_grassshrub5_02     = types.vegetation,
			t_sky_flora_grassshrub5_03     = types.vegetation,
			t_sky_flora_grassshrub6_01     = types.vegetation,
			t_sky_flora_grassshrub6_02     = types.vegetation,
			t_sky_flora_grassshrubdry1_01  = types.vegetation,
			t_sky_flora_grassshrubdry1_02  = types.vegetation,
			t_sky_flora_grassshrubmed1_01  = types.vegetation,
			t_sky_flora_grassshrubmed1_02  = types.vegetation,
			t_sky_flora_grassshrubmed1_03  = types.vegetation,
			t_sky_flora_grassshrubsml1_01  = types.vegetation,
			t_sky_flora_grassshrubsml2_01  = types.vegetation,
			t_sky_flora_grassshrubsml3_01  = types.vegetation,
			t_sky_flora_grassshrubsml4_01  = types.vegetation,
			t_sky_flora_grassshrubsml5_01  = types.vegetation,
			t_sky_flora_grassshrubsml6_01  = types.vegetation,
			t_sky_flora_grassshrubsml7_01  = types.vegetation,
			t_sky_flora_grassshrubsml8_01  = types.vegetation,
			t_sky_flora_grassshrubsml9_01  = types.vegetation,
			t_sky_flora_grasssnow1_01      = types.vegetation,
			t_sky_flora_grasssnow1_02      = types.vegetation,
			t_sky_flora_grasssnow1_03      = types.vegetation,
			t_sky_flora_hellebore01        = types.vegetation,
			t_sky_flora_hellebore02        = types.vegetation,
			t_sky_flora_hellebore03        = types.vegetation,
			t_sky_flora_hollywrea01        = types.vegetation,
			t_sky_flora_honeylill01        = types.vegetation,
			t_sky_flora_honeylill02        = types.vegetation,
			t_sky_flora_honeylill03        = types.vegetation,
			t_sky_flora_honeylill04        = types.vegetation,
			t_sky_flora_honeylill05        = types.vegetation,
			t_sky_flora_honeylill06        = types.vegetation,
			t_sky_flora_icyshell01         = types.vegetation,
			t_sky_flora_ironwood01         = types.vegetation,
			t_sky_flora_ironwood02         = types.vegetation,
			t_sky_flora_ironwood03         = types.vegetation,
			t_sky_flora_jarmush01          = types.vegetation,
			t_sky_flora_kingbol01          = types.vegetation,
			t_sky_flora_kingbol02          = types.vegetation,
			t_sky_flora_kingbol03          = types.vegetation,
			t_sky_flora_kingbol04          = types.vegetation,
			t_sky_flora_kingbol05          = types.vegetation,
			t_sky_flora_kingbolsn01        = types.vegetation,
			t_sky_flora_kingbolsn02        = types.vegetation,
			t_sky_flora_kingbolsn03        = types.vegetation,
			t_sky_flora_kingbolsn04        = types.vegetation,
			t_sky_flora_kingbolsn05        = types.vegetation,
			t_sky_flora_kingthist01        = types.vegetation,
			t_sky_flora_kingthist02        = types.vegetation,
			t_sky_flora_lichen01           = types.vegetation,
			t_sky_flora_lichencav01        = types.vegetation,
			t_sky_flora_lizardf01          = types.vegetation,
			t_sky_flora_lizardf02          = types.vegetation,
			t_sky_flora_moosebite01        = types.vegetation,
			t_sky_flora_moosebite02        = types.vegetation,
			t_sky_flora_mustard01          = types.vegetation,
			t_sky_flora_seaweed_01         = types.vegetation,
			t_sky_flora_seaweed_02         = types.vegetation,
			t_sky_flora_seaweedhang_01     = types.vegetation,
			t_sky_flora_seaweedhang_02     = types.vegetation,
			t_sky_flora_seaweedhang_03     = types.vegetation,
			t_sky_flora_seaweedhang_04     = types.vegetation,
			t_sky_flora_snowberry01        = types.vegetation,
			t_sky_flora_swmpchal01         = types.vegetation,
			t_sky_flora_taragetis01        = types.vegetation,
			t_sky_flora_taragetis02        = types.vegetation,
			t_sky_flora_taragetis03        = types.vegetation,
			t_sky_flora_taragetis04        = types.vegetation,
			t_sky_flora_taragetis05        = types.vegetation,
			t_sky_flora_tawnfun01          = types.vegetation,
			t_sky_flora_tawnfun02          = types.vegetation,
			t_sky_flora_tawnfun03          = types.vegetation,
			t_sky_flora_tawnfunsn01        = types.vegetation,
			t_sky_flora_tawnfunsn02        = types.vegetation,
			t_sky_flora_tawnfunsn03        = types.vegetation,
			t_sky_flora_treebirchbush_01   = types.vegetation,
			t_sky_flora_treebirchbush_02   = types.vegetation,
			t_sky_flora_treebirchbush_03   = types.vegetation,
			t_sky_flora_treebirchbush_04   = types.vegetation,
			t_sky_flora_tremblwee01        = types.vegetation,
			t_sky_flora_trollroot01        = types.vegetation,
			t_sky_flora_trollroot02        = types.vegetation,
			t_sky_flora_turnip01           = types.vegetation,
			t_sky_flora_vicherb01          = types.vegetation,
			t_sky_flora_vicherb02          = types.vegetation,
			t_sky_flora_vicHerbH01         = types.vegetation,
			t_sky_flora_widowkisd01        = types.vegetation,
			t_sky_flora_widowkiss01        = types.vegetation,
			t_sky_flora_withWheat01        = types.vegetation,
			t_sky_flora_withWheat02        = types.vegetation,
			t_sky_flora_withWheat03        = types.vegetation,
			t_sky_flora_woadfl01           = types.vegetation,
			t_sky_flora_wormwood01         = types.vegetation,
			t_sky_flora_wormwoodD01        = types.vegetation,
			t_sky_flora_wrothggrap01       = types.vegetation,

			-- Trees
			  -- Global
			t_glb_flora_treejoshua_01       = types.tree,
			t_glb_flora_treejoshua_02       = types.tree,
			t_glb_flora_treejoshua_03       = types.tree,
			t_glb_flora_treejoshua_04       = types.tree,
			t_glb_flora_treejoshua_05       = types.tree,
			t_glb_flora_mangrove_01         = types.tree,
			t_glb_flora_mangrove_02         = types.tree,
			t_glb_flora_mangrove_03         = types.tree,
			t_glb_flora_mangrove_04         = types.tree,
			  -- Cyrodiil
			t_cyr_flora_treepoplar_01       = types.tree,
			t_cyr_florabw_tree_01           = types.tree,
			t_cyr_florabw_tree_02           = types.tree,
			t_cyr_florabw_tree_03           = types.tree,
			t_cyr_florach_tree_01           = types.tree,
			t_cyr_florach_tree_02           = types.tree,
			t_cyr_florach_tree_03           = types.tree,
			t_cyr_florach_tree_04           = types.tree,
			t_cyr_florach_tree_05           = types.tree,
			t_cyr_florach_tree_06           = types.tree,
			t_cyr_florach_tree_07           = types.tree,
			t_cyr_florach_tree_08           = types.tree,
			t_cyr_florach_tree_09           = types.tree,
			t_cyr_florach_tree_10           = types.tree,
			t_cyr_florach_tree_11           = types.tree,
			t_cyr_florach_tree_12           = types.tree,
			t_cyr_floragc_tree_01           = types.tree,
			t_cyr_floragc_tree_02           = types.tree,
			t_cyr_floragc_tree_03           = types.tree,
			t_cyr_floragc_tree_04           = types.tree,
			t_cyr_floragc_tree_05           = types.tree,
			t_cyr_floragc_tree_06           = types.tree,
			t_cyr_floragc_treeoak_01        = types.tree,
			t_cyr_floragc_treeoak_02        = types.tree,
			t_cyr_floragc_treeoak_03        = types.tree,
			t_cyr_floragc_treeolive_01      = types.tree,
			t_cyr_floragc_treeolive_02      = types.tree,
			t_cyr_floragc_treeolive_03      = types.tree,
			t_cyr_floragc_treepalm_01       = types.tree,
			t_cyr_floragc_treepalm_02       = types.tree,
			t_cyr_floragc_treepalm_03       = types.tree,
			t_cyr_floragc_treepalm_04       = types.tree,
			t_cyr_floragc_treepalm_05       = types.tree,
			t_cyr_floragh_tree_01           = types.tree,
			t_cyr_floragh_tree_02           = types.tree,
			t_cyr_floragh_tree_03           = types.tree,
			t_cyr_floragh_tree_04           = types.tree,
			t_cyr_floragh_tree_05           = types.tree,
			t_cyr_floragh_tree_06           = types.tree,
			t_cyr_floragh_tree_07           = types.tree,
			t_cyr_floragh_tree_08           = types.tree,
			t_cyr_florahl_tree_01           = types.tree,
			t_cyr_florahl_tree_02           = types.tree,
			t_cyr_florakp_tree_01           = types.tree,
			t_cyr_florakp_tree_02           = types.tree,
			t_cyr_florakp_tree_03           = types.tree,
			t_cyr_florajm_tree_01           = types.tree,
			t_cyr_florastr_tree_01          = types.tree,
			t_cyr_florastr_tree_02          = types.tree,
			t_cyr_florastr_tree_03          = types.tree,
			t_cyr_florastr_tree_04          = types.tree,
			t_cyr_florastr_tree_05          = types.tree,
			t_cyr_florastr_treej_01         = types.tree,
			t_cyr_florastr_treej_02         = types.tree,
			t_cyr_florastr_treej_03         = types.tree,
			t_cyr_florastr_treej_04         = types.tree,
			t_cyr_florastr_treej_05         = types.tree,
			t_cyr_floravm_tree_01           = types.tree,
			t_cyr_floravm_tree_02           = types.tree,
			t_cyr_floravm_tree_03           = types.tree,
			t_cyr_floravm_tree_04           = types.tree,
			t_cyr_floravm_tree_05           = types.tree,
			t_cyr_floravm_tree_06           = types.tree,
			t_cyr_floraww_tree_01           = types.tree,
			  -- Elsweyr
			t_els_florakr_palmtree_01       = types.tree,
			t_els_florakr_palmtree_02       = types.tree,
			t_els_florakr_palmtree_03       = types.tree,
			t_els_florakr_palmtree_04       = types.tree,
			t_els_florakr_palmtree_05       = types.tree,
			  -- Hammerfell
			t_ham_florarl_treecarnivore_01  = types.tree,
			t_ham_florarl_treecarnivore_02  = types.tree,
			t_ham_florarl_treecarnivore_03  = types.tree,
			t_ham_florarl_treecarnivore_04  = types.tree,
			t_ham_florarl_treecarnivore_05  = types.tree,
			t_ham_florarl_treecarnivore_06  = types.tree,
			t_ham_florarl_treecarnivore_07  = types.tree,
			t_ham_florarl_treecarnivore_08  = types.tree,
			t_hr_floradf_tree_01            = types.tree,
			t_hr_floradf_tree_02            = types.tree,
			t_hr_floradf_tree_03            = types.tree,
			t_hr_floradf_tree_04            = types.tree,
			t_ham_flora_treeolive_01        = types.tree,
			t_ham_flora_treeolive_02        = types.tree,
			t_ham_flora_treeolive_03        = types.tree,
			t_ham_flora_treeolive_04        = types.tree,
			  -- Morrowind
			t_mw_flora_munzur_01            = types.tree,
			t_mw_flora_munzur_02            = types.tree,
			t_mw_flora_munzur_03            = types.tree,
			t_mw_flora_towparasol_01        = types.tree,
			t_mw_flora_towparasol_02        = types.tree,
			t_mw_flora_towparasol_03        = types.tree,
			t_mw_flora_towparasol_04        = types.tree,
			t_mw_flora_towparasol_05        = types.tree,
			t_mw_flora_towparasol_06        = types.tree,
			t_mw_flora_towparasol_07        = types.tree,
			t_mw_flora_towparasol_08        = types.tree,
			t_mw_flora_towparasol_09        = types.tree,
			t_mw_flora_towparasol_10        = types.tree,
			t_mw_flora_towparasol_11        = types.tree,
			t_mw_flora_terrastree_01        = types.tree,
			t_mw_flora_terrastree_02        = types.tree,
			t_mw_flora_terrastree_03        = types.tree,
			t_mw_flora_terrastree_04        = types.tree,
			t_mw_flora_treendb_01           = types.tree,
			t_mw_flora_treendb_02           = types.tree,
			t_mw_flora_treendb_03           = types.tree,
			t_mw_flora_treendb_04           = types.tree,
			t_mw_flora_treendb_05           = types.tree,
			t_mw_flora_treendb_06           = types.tree,
			t_mw_flora_treendg_01           = types.tree,
			t_mw_flora_treendg_02           = types.tree,
			t_mw_flora_treendg_03           = types.tree,
			t_mw_flora_treendg_04           = types.tree,
			t_mw_flora_treendg_05           = types.tree,
			t_mw_flora_treendg_06           = types.tree,
			t_mw_flora_treenecrom_01        = types.tree,
			t_mw_flora_treenecrom_02        = types.tree,
			t_mw_flora_treeoak_01           = types.tree,
			t_mw_flora_treeoak_02           = types.tree,
			t_mw_flora_treeoak_03           = types.tree,
			t_mw_floraaj_tree_01            = types.tree,
			t_mw_floraaj_tree_02            = types.tree,
			t_mw_floraaj_tree_03            = types.tree,
			t_mw_floraaj_tree_04            = types.tree,
			t_mw_floraaj_tree_05            = types.tree,
			t_mw_floraaj_tree_06            = types.tree,
			t_mw_floraaj_tree_07            = types.tree,
			t_mw_floraaj_tree_08            = types.tree,
			t_mw_floraaj_tree_09            = types.tree,
			t_mw_floraat_treeb_01           = types.tree,
			t_mw_floraat_treeb_02           = types.tree,
			t_mw_floraat_treeb_03           = types.tree,
			t_mw_floraat_treeb_04           = types.tree,
			t_mw_floraat_treeb_05           = types.tree,
			t_mw_floraat_treeb_06           = types.tree,
			t_mw_floraat_treeg_01           = types.tree,
			t_mw_floraat_treeg_02           = types.tree,
			t_mw_floraat_treeg_03           = types.tree,
			t_mw_floraat_treeg_04           = types.tree,
			t_mw_floraat_treeg_05           = types.tree,
			t_mw_floraat_treeg_06           = types.tree,
			t_mw_floracm_maiden03           = types.tree,
			t_mw_floracm_maiden04           = types.tree,
			t_mw_floracm_maiden05           = types.tree,
			t_mw_floracm_maiden06           = types.tree,
			t_mw_floragm_empparasol_01      = types.tree,
			t_mw_floragm_empparasol_02      = types.tree,
			t_mw_floragm_empparasol_03      = types.tree,
			t_mw_floragm_empparasol_04      = types.tree,
			t_mw_floragm_tree_01            = types.tree,
			t_mw_floragm_tree_02            = types.tree,
			t_mw_floraow_ovarytree_01       = types.tree,
			t_mw_floraow_ovarytree_02       = types.tree,
			t_mw_floraow_ovarytree_03       = types.tree,
			t_mw_floratv_manshroom_01       = types.tree,
			t_mw_floratv_manshroom_02       = types.tree,
			t_mw_floratv_manshroom_03       = types.tree,
			t_mw_floratv_manshroom_04       = types.tree,
			t_mw_floratv_manshroom_05       = types.tree,
			t_mw_floratv_manshroom_06       = types.tree,
			t_mw_floratv_manshroom_07       = types.tree,
			t_mw_floratv_treegeran_01       = types.tree,
			t_mw_floratv_treegeran_02       = types.tree,
			t_mw_floratv_treegeran_03       = types.tree,
			t_mw_floratv_treegeran_04       = types.tree,
			t_mw_floratv_treegeran_05       = types.tree,
			t_mw_floratv_treegeran_06       = types.tree,
			t_mw_floratv_treegeran_07       = types.tree,
			t_mw_floratv_treegeran_08       = types.tree,
			  -- Skyrim
			t_sky_flora_bushleaves1_01      = types.tree,
			t_sky_flora_bushleaves1_02      = types.tree,
			t_sky_flora_bushleaves1dry_01   = types.tree,
			t_sky_flora_bushleaves1dry_02   = types.tree,
			t_sky_flora_bushpine1_01        = types.tree,
			t_sky_flora_bushpine1_02        = types.tree,
			t_sky_flora_bushpine1dry_01     = types.tree,
			t_sky_flora_bushpine1dry_02     = types.tree,
			t_sky_flora_bushpine1snow_01    = types.tree,
			t_sky_flora_bushpine1snow_02    = types.tree,
			t_sky_flora_bushleaves2_01      = types.tree,
			t_sky_flora_bushleaves2_02      = types.tree,
			t_sky_flora_bushleaves3_01      = types.tree,
			t_sky_flora_bushleaves3_02      = types.tree,
			t_sky_flora_bushleaves3_03      = types.tree,
			t_sky_flora_bushleaves4_01      = types.tree,
			t_sky_flora_bushleaves4_02      = types.tree,
			t_sky_flora_bushleaves5_01      = types.tree,
			t_sky_flora_bushleaves5_02      = types.tree,
			t_sky_flora_bushleaves5_03      = types.tree,
			t_sky_flora_bushleaves5dry_01   = types.tree,
			t_sky_flora_bushleaves5dry_02   = types.tree,
			t_sky_flora_bushleaves5dry_03   = types.tree,
			t_sky_flora_bushpine3_01        = types.tree,
			t_sky_flora_bushpine3_02        = types.tree,
			t_sky_flora_bushpine3_03        = types.tree,
			t_sky_flora_bushpine3dry_01     = types.tree,
			t_sky_flora_bushpine3dry_02     = types.tree,
			t_sky_flora_bushpine3dry_03     = types.tree,
			t_sky_flora_bushpine3snow_01    = types.tree,
			t_sky_flora_bushpine3snow_02    = types.tree,
			t_sky_flora_bushpine3snow_03    = types.tree,
			t_sky_flora_bushpine4_01        = types.tree,
			t_sky_flora_bushpine4_02        = types.tree,
			t_sky_flora_bushpine4dry_01     = types.tree,
			t_sky_flora_bushpine4dry_02     = types.tree,
			t_sky_flora_bushpine4snow_01    = types.tree,
			t_sky_flora_bushpine4snow_02    = types.tree,
			t_sky_flora_bushplain1_01       = types.tree,
			t_sky_flora_bushplain1_02       = types.tree,
			t_sky_flora_bushplain1_03       = types.tree,
			t_sky_flora_treebirch1_01       = types.tree,
			t_sky_flora_treebirch1_02       = types.tree,
			t_sky_flora_treebirch1_03       = types.tree,
			t_sky_flora_treebirch1_04       = types.tree,
			t_sky_flora_treebirch1_05       = types.tree,
			t_sky_flora_treebirch1_06       = types.tree,
			t_sky_flora_treebirch1_07       = types.tree,
			t_sky_flora_treebirch1_08       = types.tree,
			t_sky_flora_treebirch2_01       = types.tree,
			t_sky_flora_treebirch2_02       = types.tree,
			t_sky_flora_treebirch2_03       = types.tree,
			t_sky_flora_treebirch2_04       = types.tree,
			t_sky_flora_treebirch2_05       = types.tree,
			t_sky_flora_treebirch2_06       = types.tree,
			t_sky_flora_treebirch2_07       = types.tree,
			t_sky_flora_treebirch2_08       = types.tree,
			t_sky_flora_treebirch3_01       = types.tree,
			t_sky_flora_treebirch3_02       = types.tree,
			t_sky_flora_treebirch3_03       = types.tree,
			t_sky_flora_treebirch3_04       = types.tree,
			t_sky_flora_treebirch3_05       = types.tree,
			t_sky_flora_treebirch3_06       = types.tree,
			t_sky_flora_treebirch3_07       = types.tree,
			t_sky_flora_treebirch3_08       = types.tree,
			t_sky_flora_treebirchdry_01     = types.tree,
			t_sky_flora_treebirchdry_02     = types.tree,
			t_sky_flora_treebirchdry_03     = types.tree,
			t_sky_flora_treebirchdry_04     = types.tree,
			t_sky_flora_treebirchdry_05     = types.tree,
			t_sky_flora_treebirchdry_06     = types.tree,
			t_sky_flora_treebirchdry_07     = types.tree,
			t_sky_flora_treebirchdry_08     = types.tree,
			t_sky_flora_treebirchdry_09     = types.tree,
			t_sky_flora_treebirchdry_10     = types.tree,
			t_sky_flora_treebirchdry_11     = types.tree,
			t_sky_flora_treebirchdry_12     = types.tree,
			t_sky_flora_treebirchdry_13     = types.tree,
			t_sky_flora_treebirchdry_14     = types.tree,
			t_sky_flora_treelarch01_01      = types.tree,
			t_sky_flora_treelarch01_02      = types.tree,
			t_sky_flora_treelarch01_03      = types.tree,
			t_sky_flora_treelarch02_01      = types.tree,
			t_sky_flora_treelarch02_02      = types.tree,
			t_sky_flora_treelarch02_03      = types.tree,
			t_sky_flora_treelarch03_01      = types.tree,
			t_sky_flora_treelarch03_02      = types.tree,
			t_sky_flora_treelarch03_03      = types.tree,
			t_sky_flora_treelarch04_01      = types.tree,
			t_sky_flora_treelarch04_02      = types.tree,
			t_sky_flora_treelarch04_03      = types.tree,
			t_sky_flora_treelarch05_01      = types.tree,
			t_sky_flora_treelarch05_02      = types.tree,
			t_sky_flora_treelarch05_03      = types.tree,
			t_sky_flora_treelarch06_01      = types.tree,
			t_sky_flora_treelarch06_02      = types.tree,
			t_sky_flora_treelarch06_03      = types.tree,
			t_sky_flora_treelarchbrn01_01   = types.tree,
			t_sky_flora_treelarchbrn01_02   = types.tree,
			t_sky_flora_treelarchbrn02_01   = types.tree,
			t_sky_flora_treelarchbrn02_02   = types.tree,
			t_sky_flora_treelarchbrn03_01   = types.tree,
			t_sky_flora_treelarchbrn03_02   = types.tree,
			t_sky_flora_treelarchdry_01     = types.tree,
			t_sky_flora_treelarchdry_02     = types.tree,
			t_sky_flora_treelarchdry_03     = types.tree,
			t_sky_flora_treelarchdry_04     = types.tree,
			t_sky_flora_treelarchsnow01_01  = types.tree,
			t_sky_flora_treelarchsnow01_02  = types.tree,
			t_sky_flora_treelarchsnow01_03  = types.tree,
			t_sky_flora_treelarchsnow02_01  = types.tree,
			t_sky_flora_treelarchsnow02_02  = types.tree,
			t_sky_flora_treelarchsnow02_03  = types.tree,
			t_sky_flora_treelarchsnow03_01  = types.tree,
			t_sky_flora_treelarchsnow03_02  = types.tree,
			t_sky_flora_treelarchsnow03_03  = types.tree,
			t_sky_flora_treelarchsnow04_01  = types.tree,
			t_sky_flora_treelarchsnow04_02  = types.tree,
			t_sky_flora_treelarchsnow04_03  = types.tree,
			t_sky_flora_treelarchsnow05_01  = types.tree,
			t_sky_flora_treelarchsnow05_02  = types.tree,
			t_sky_flora_treelarchsnow05_03  = types.tree,
			t_sky_flora_treelarchsnow06_01  = types.tree,
			t_sky_flora_treelarchsnow06_02  = types.tree,
			t_sky_flora_treelarchsnow06_03  = types.tree,
			t_sky_flora_treelarchsnowdry_01 = types.tree,
			t_sky_flora_treelarchsnowdry_02 = types.tree,
			t_sky_flora_treelarchsnowdry_03 = types.tree,
			t_sky_flora_treelarchsnowdry_04 = types.tree,
			t_sky_flora_treeleaf1_01        = types.tree,
			t_sky_flora_treeleaf1_02        = types.tree,
			t_sky_flora_treeleaf1_03        = types.tree,
			t_sky_flora_treeleaf1dry_01     = types.tree,
			t_sky_flora_treeleaf1dry_02     = types.tree,
			t_sky_flora_treeleaf1dry_03     = types.tree,
			t_sky_flora_treeleaf1plain_01   = types.tree,
			t_sky_flora_treeleaf1plain_02   = types.tree,
			t_sky_flora_treeleaf1plain_03   = types.tree,
			t_sky_flora_treeleaf2_01        = types.tree,
			t_sky_flora_treeleaf2_02        = types.tree,
			t_sky_flora_treeleaf2_03        = types.tree,
			t_sky_flora_treeleaf2dry_01     = types.tree,
			t_sky_flora_treeleaf2dry_02     = types.tree,
			t_sky_flora_treeleaf2dry_03     = types.tree,
			t_sky_flora_treeleaf2plain_01   = types.tree,
			t_sky_flora_treeleaf2plain_02   = types.tree,
			t_sky_flora_treeleaf2plain_03   = types.tree,
			t_sky_flora_treeleaf3_01        = types.tree,
			t_sky_flora_treeleaf3_02        = types.tree,
			t_sky_flora_treeleaf3_03        = types.tree,
			t_sky_flora_treeleaf3_04        = types.tree,
			t_sky_flora_treepine1_01        = types.tree,
			t_sky_flora_treepine1_02        = types.tree,
			t_sky_flora_treepine1_03        = types.tree,
			t_sky_flora_treepine1_04        = types.tree,
			t_sky_flora_treepine1_05        = types.tree,
			t_sky_flora_treepine1_06        = types.tree,
			t_sky_flora_treepine1_07        = types.tree,
			t_sky_flora_treepine1snow_01    = types.tree,
			t_sky_flora_treepine1snow_02    = types.tree,
			t_sky_flora_treepine1snow_03    = types.tree,
			t_sky_flora_treepine1snow_04    = types.tree,
			t_sky_flora_treepine1snow_05    = types.tree,
			t_sky_flora_treepine1snow_06    = types.tree,
			t_sky_flora_treepine1snow_07    = types.tree,
			t_sky_flora_treepine2_01        = types.tree,
			t_sky_flora_treepine2_02        = types.tree,
			t_sky_flora_treepine2_03        = types.tree,
			t_sky_flora_treepine2_04        = types.tree,
			t_sky_flora_treepine2_05        = types.tree,
			t_sky_flora_treepine2_06        = types.tree,
			t_sky_flora_treepine2_07        = types.tree,
			t_sky_flora_treepine2snow_01    = types.tree,
			t_sky_flora_treepine2snow_02    = types.tree,
			t_sky_flora_treepine2snow_03    = types.tree,
			t_sky_flora_treepine2snow_04    = types.tree,
			t_sky_flora_treepine2snow_05    = types.tree,
			t_sky_flora_treepine2snow_06    = types.tree,
			t_sky_flora_treepine2snow_07    = types.tree,
			t_sky_flora_treepine3_01        = types.tree,
			t_sky_flora_treepine3_02        = types.tree,
			t_sky_flora_treepine3_03        = types.tree,
			t_sky_flora_treepine3_04        = types.tree,
			t_sky_flora_treepine3_05        = types.tree,
			t_sky_flora_treepine3_06        = types.tree,
			t_sky_flora_treepine3_07        = types.tree,
			t_sky_flora_treepine3_08        = types.tree,
			t_sky_flora_treepine3_09        = types.tree,
			t_sky_flora_treepine3snow_01    = types.tree,
			t_sky_flora_treepine3snow_02    = types.tree,
			t_sky_flora_treepine3snow_03    = types.tree,
			t_sky_flora_treepine3snow_04    = types.tree,
			t_sky_flora_treepine3snow_05    = types.tree,
			t_sky_flora_treepine3snow_06    = types.tree,
			t_sky_flora_treepine3snow_07    = types.tree,
			t_sky_flora_treepine3snow_08    = types.tree,
			t_sky_flora_treepine3snow_09    = types.tree,
			t_sky_flora_treepine4_01        = types.tree,
			t_sky_flora_treepine4_02        = types.tree,
			t_sky_flora_treepine4_03        = types.tree,
			t_sky_flora_treepine4snow_01    = types.tree,
			t_sky_flora_treepine4snow_02    = types.tree,
			t_sky_flora_treepine4snow_03    = types.tree,
			t_sky_flora_treepine5_01        = types.tree,
			t_sky_flora_treepine5_02        = types.tree,
			t_sky_flora_treepine5_03        = types.tree,
			t_sky_flora_treepine5snow_01    = types.tree,
			t_sky_flora_treepine5snow_02    = types.tree,
			t_sky_flora_treepine5snow_03    = types.tree,
			t_sky_flora_treepine6_01        = types.tree,
			t_sky_flora_treepine6_02        = types.tree,
			t_sky_flora_treepine6_03        = types.tree,
			t_sky_flora_treepine6snow_01    = types.tree,
			t_sky_flora_treepine6snow_02    = types.tree,
			t_sky_flora_treepine6snow_03    = types.tree,
			t_sky_flora_treepine7_01        = types.tree,
			t_sky_flora_treepine7_02        = types.tree,
			t_sky_flora_treepine7_03        = types.tree,
			t_sky_flora_treepine7_04        = types.tree,
			t_sky_flora_treepine7_05        = types.tree,
			t_sky_flora_treepine7_06        = types.tree,
			t_sky_flora_treepine7_07        = types.tree,
			t_sky_flora_treepine7snow_01    = types.tree,
			t_sky_flora_treepine7snow_02    = types.tree,
			t_sky_flora_treepine7snow_03    = types.tree,
			t_sky_flora_treepine7snow_04    = types.tree,
			t_sky_flora_treepine7snow_05    = types.tree,
			t_sky_flora_treepine7snow_06    = types.tree,
			t_sky_flora_treepine7snow_07    = types.tree,
			t_sky_flora_treepine7snow_08    = types.tree,
			t_sky_flora_treepine7snow_09    = types.tree,
			t_sky_flora_treepine7snow_10    = types.tree,
			t_sky_flora_treepine7snow_11    = types.tree,
			t_sky_flora_treepine7snow_12    = types.tree,
			t_sky_flora_treepine7snow_13    = types.tree,
			t_sky_flora_treepine7snow_14    = types.tree,

			-- Wood
			  -- Global
			t_glb_driftwood_01			  = types.wood,
			t_glb_driftwood_02			  = types.wood,
			t_glb_driftwood_03			  = types.wood,
			t_glb_driftwood_04			  = types.wood,
			t_glb_driftwood_05			  = types.wood,
			t_glb_flora_mangroveroots_01  = types.wood,
			t_glb_flora_mangroveroots_02  = types.wood,
			t_glb_flora_mangroveroots_03  = types.wood,
			t_glb_flora_mangroveroots_04  = types.wood,
			  -- Cyrodiil
			t_imp_setgc_x_palmlogs_01     = types.wood,
			t_cyr_florach_treelog_01      = types.wood,
			t_cyr_florach_treelog_02      = types.wood,
			t_cyr_floragc_treelog_01      = types.wood,
			t_cyr_floragc_treelog_02      = types.wood,
			t_cyr_floragc_treelog_03      = types.wood,
			t_cyr_floragc_treelog_04      = types.wood,
			t_cyr_florakp_treelog_01      = types.wood,
			t_cyr_florakp_treelog_02      = types.wood,
			  -- Morrowind
			t_mw_flora_tramashrub_01      = types.wood,
			t_mw_flora_tramashrub_02      = types.wood,
			t_mw_flora_tramashrub_03      = types.wood,
			t_mw_flora_tramashrub_04      = types.wood,
			t_mw_flora_treeailog_01       = types.wood,
			t_mw_flora_treeailog_02       = types.wood,
			t_mw_flora_treeailog_03       = types.wood,
			t_mw_flora_treeailog_04       = types.wood,
			t_mw_flora_treeailog_05       = types.wood,
			t_mw_flora_treeailog_06       = types.wood,
			t_mw_flora_treeailog_07       = types.wood,
			t_mw_flora_treeailog_08       = types.wood,
			t_mw_flora_treeailog_09       = types.wood,
			t_mw_flora_treeailog_10       = types.wood,
			t_mw_floragm_log_01           = types.wood,
			t_mw_floragm_log_02           = types.wood,
			t_mw_floraor_gorappletree_01  = types.wood,
			t_mw_floraor_gorappletree_02  = types.wood,
			t_mw_floraor_gorappletree_03  = types.wood,
			t_mw_floraor_gorappletree_04  = types.wood,
			t_mw_floraor_gorappletree_05  = types.wood,
			t_mw_floraor_gorappletree_06  = types.wood,
			t_mw_floraor_gorappletree_07  = types.wood,
			t_mw_floraow_cupling_01       = types.wood,
			t_mw_floraow_cupling_02       = types.wood,
			t_mw_floraow_cupling_03       = types.wood,
			t_mw_floraow_cupling_04       = types.wood,
			t_mw_floraow_cupling_05       = types.wood,
			t_mw_floraow_cupling_06       = types.wood,
			t_mw_floraow_ovarysprout_01   = types.wood,
			t_mw_floraow_ovarysprout_02   = types.wood,
			t_mw_floraow_ovarysprout_03   = types.wood,
			t_mw_floraow_tallmush_01      = types.wood,
			t_mw_floraow_tallmush_02      = types.wood,
			t_mw_floraow_tallmush_03      = types.wood,
			t_mw_floraow_tallmush_04      = types.wood,
			t_mw_floraow_tallmush_05      = types.wood,
			t_mw_floraow_tallmush_06      = types.wood,
			t_mw_floratv_manshroomroot_01 = types.wood,
			t_mw_floratv_manshroomroot_02 = types.wood,
			t_mw_floratv_manshroomroot_03 = types.wood,
			t_mw_floratv_manshroomroot_04 = types.wood,
			t_mw_floratv_manshroomroot_05 = types.wood,
			t_mw_floratv_manshroomroot_06 = types.wood,
			t_mw_floratv_manshroomroot_07 = types.wood,
			t_mw_floratv_manshroomroot_08 = types.wood,
			t_mw_floratv_treegeranlog_01  = types.wood,
			  -- Skyrim
			t_sky_flora_driftwood_01        = types.wood,
			t_sky_flora_driftwood_02        = types.wood,
			t_sky_flora_driftwood_03        = types.wood,
			t_sky_flora_treebirchbranch_01  = types.wood,
			t_sky_flora_treebirchbranch_02  = types.wood,
			t_sky_flora_treebirchbranch_03  = types.wood,
			t_sky_flora_treebirchbranch_04  = types.wood,
			t_sky_flora_treebirchlog_01     = types.wood,
			t_sky_flora_treebirchlog_02     = types.wood,
			t_sky_flora_treebirchlog_03     = types.wood,
			t_sky_flora_treebirchsnowlog_01 = types.wood,
			t_sky_flora_treebirchsnowlog_02 = types.wood,
			t_sky_flora_treebirchsnowlog_03 = types.wood,
			t_sky_flora_treelarchlog_01     = types.wood,
			t_sky_flora_treelarchlog_02     = types.wood,
			t_sky_flora_treelarchsnowlog_01 = types.wood,
			t_sky_flora_treelarchsnowlog_02 = types.wood,
			t_sky_flora_treeleaf1log_01     = types.wood,
			t_sky_flora_treeleaf1log_02     = types.wood,
			t_sky_flora_treeleaf1log_03     = types.wood,
			t_sky_flora_treeleaf1log_04     = types.wood,
			t_sky_flora_treeleaf2log_01     = types.wood,
			t_sky_flora_treeleaf2log_02     = types.wood,
			t_sky_flora_treeleaf2log_03     = types.wood,
			t_sky_flora_treeleaf2log_04     = types.wood,
			t_sky_flora_treepine1log_01     = types.wood,
			t_sky_flora_treepine1log_02     = types.wood,
			t_sky_flora_treepine1log_03     = types.wood,
			t_sky_flora_treepine1log_04     = types.wood,
			t_sky_flora_treepine1log_05     = types.wood,
			t_sky_flora_treepine1snowlog_01 = types.wood,
			t_sky_flora_treepine1snowlog_02 = types.wood,
			t_sky_flora_treepine1snowlog_03 = types.wood,
			t_sky_flora_treepine1snowlog_04 = types.wood,
			t_sky_flora_treepine1snowlog_05 = types.wood,
			t_sky_flora_treepine3log_01     = types.wood,
			t_sky_flora_treepine3log_02     = types.wood,
			t_sky_flora_treepine3log_03     = types.wood,
			t_sky_flora_treepine3log_04     = types.wood,
			t_sky_flora_treepine3log_05     = types.wood,
			t_sky_flora_treepine3snowlog_01 = types.wood,
			t_sky_flora_treepine3snowlog_02 = types.wood,
			t_sky_flora_treepine3snowlog_03 = types.wood,
			t_sky_flora_treepine3snowlog_04 = types.wood,
			t_sky_flora_treepine3snowlog_05 = types.wood,
			t_sky_flora_treepine6log_01     = types.wood,
			t_sky_flora_treepine6log_02     = types.wood,
			t_sky_flora_treepine6snowlog_01 = types.wood,
			t_sky_flora_treepine6snowlog_02 = types.wood,
			t_sky_flora_treepine7log_01     = types.wood,
			t_sky_flora_treepine7log_02     = types.wood,
			t_sky_flora_treepine7log_03     = types.wood,
			t_sky_flora_treepine7log_04     = types.wood,
			t_sky_flora_treepine7log_05     = types.wood,
			t_sky_flora_treepine7snowlog_01 = types.wood,
			t_sky_flora_treepine7snowlog_02 = types.wood,
			t_sky_flora_treepine7snowlog_03 = types.wood,
			t_sky_flora_treepine7snowlog_04 = types.wood,
			t_sky_flora_treepine7snowlog_05 = types.wood,

			-- Stump
			  -- Cyrodiil
			t_cyr_florach_treestump_01      = types.stump,
			t_cyr_florach_treestump_02      = types.stump,
			t_cyr_floragc_treestump_01      = types.stump,
			t_cyr_floragc_treestump_02      = types.stump,
			t_cyr_floragc_treestump_03      = types.stump,
			t_cyr_floragc_treestump_04      = types.stump,
			t_cyr_florakp_treestump_01      = types.stump,
			  -- Morrowind
			t_mw_flora_treeaistump_01       = types.stump,
			t_mw_flora_treeaistump_02       = types.stump,
			t_mw_flora_treeaistump_03       = types.stump,
			t_mw_flora_treeaistump_04       = types.stump,
			t_mw_flora_treeaistump_05       = types.stump,
			t_mw_flora_treeaistump_06       = types.stump,
			t_mw_flora_treeaistump_07       = types.stump,
			t_mw_flora_treeaistump_08       = types.stump,
			t_mw_flora_treeaistump_09       = types.stump,
			t_mw_flora_treeaistump_10       = types.stump,
			t_mw_flora_treeaistump_11       = types.stump,
			t_mw_flora_treeaistump_12       = types.stump,
			t_mw_flora_treendstump_01       = types.stump,
			t_mw_flora_treendstump_02       = types.stump,
			t_mw_flora_treendstump_03       = types.stump,
			t_mw_flora_treendstump_04       = types.stump,
			t_mw_floraat_stump_01           = types.stump,
			t_mw_floraat_stump_02           = types.stump,
			t_mw_floraat_stump_03           = types.stump,
			t_mw_floraat_stump_04           = types.stump,
			t_mw_floragm_stump_01           = types.stump,
			t_mw_floratv_manshroomstump_01  = types.stump,
			t_mw_floratv_treegeranstump_01  = types.stump,
			  -- Skyrim
			t_sky_flora_treebirchsnowstm_01 = types.stump,
			t_sky_flora_treebirchsnowstm_02 = types.stump,
			t_sky_flora_treebirchsnowstm_03 = types.stump,
			t_sky_flora_treebirchsnowstm_04 = types.stump,
			t_sky_flora_treebirchstm_01     = types.stump,
			t_sky_flora_treebirchstm_02     = types.stump,
			t_sky_flora_treebirchstm_03     = types.stump,
			t_sky_flora_treebirchstm_04     = types.stump,
			t_sky_flora_treebirchstm_05     = types.stump,
			t_sky_flora_treebirchstm_06     = types.stump,
			t_sky_flora_treebirchstm_07     = types.stump,
			t_sky_flora_treebirchstm_08     = types.stump,
			t_sky_flora_treebirchstm_09     = types.stump,
			t_sky_flora_treebirchstm_10     = types.stump,
			t_sky_flora_treebirchstm_11     = types.stump,
			t_sky_flora_treebirchstm_12     = types.stump,
			t_sky_flora_treelarchsnowstm_01 = types.stump,
			t_sky_flora_treelarchsnowstm_02 = types.stump,
			t_sky_flora_treelarchsnowstm_03 = types.stump,
			t_sky_flora_treelarchstm_01     = types.stump,
			t_sky_flora_treelarchstm_02     = types.stump,
			t_sky_flora_treelarchstm_03     = types.stump,
			t_sky_flora_treeleaf1stump_01   = types.stump,
			t_sky_flora_treeleaf1stump_02   = types.stump,
			t_sky_flora_treeleaf1stump_03   = types.stump,
			t_sky_flora_treeleaf1stump_04   = types.stump,
			t_sky_flora_treeleaf2stump_01   = types.stump,
			t_sky_flora_treeleaf2stump_02   = types.stump,
			t_sky_flora_treeleaf2stump_03   = types.stump,
			t_sky_flora_treeleaf2stump_04   = types.stump,
			t_sky_flora_treepine1snowstm_01 = types.stump,
			t_sky_flora_treepine1snowstm_02 = types.stump,
			t_sky_flora_treepine1snowstm_03 = types.stump,
			t_sky_flora_treepine1snowstm_04 = types.stump,
			t_sky_flora_treepine1snowstm_05 = types.stump,
			t_sky_flora_treepine1snowstm_06 = types.stump,
			t_sky_flora_treepine1stump_01   = types.stump,
			t_sky_flora_treepine1stump_02   = types.stump,
			t_sky_flora_treepine1stump_03   = types.stump,
			t_sky_flora_treepine1stump_04   = types.stump,
			t_sky_flora_treepine1stump_05   = types.stump,
			t_sky_flora_treepine1stump_06   = types.stump,
			t_sky_flora_treepine3snowstm_01 = types.stump,
			t_sky_flora_treepine3snowstm_02 = types.stump,
			t_sky_flora_treepine3snowstm_03 = types.stump,
			t_sky_flora_treepine3snowstm_04 = types.stump,
			t_sky_flora_treepine3snowstm_05 = types.stump,
			t_sky_flora_treepine3snowstm_06 = types.stump,
			t_sky_flora_treepine3stump_01   = types.stump,
			t_sky_flora_treepine3stump_02   = types.stump,
			t_sky_flora_treepine3stump_03   = types.stump,
			t_sky_flora_treepine3stump_04   = types.stump,
			t_sky_flora_treepine3stump_05   = types.stump,
			t_sky_flora_treepine3stump_06   = types.stump,
			t_sky_flora_treepine4stump_01   = types.stump,
			t_sky_flora_treepine4stump_02   = types.stump,
			t_sky_flora_treepine4stump_03   = types.stump,
			t_sky_flora_treepine4stump_04   = types.stump,
			t_sky_flora_treepine6snowstm_01 = types.stump,
			t_sky_flora_treepine6stump_01   = types.stump,
			t_sky_flora_treepine7snowstm_01 = types.stump,
			t_sky_flora_treepine7snowstm_02 = types.stump,
			t_sky_flora_treepine7snowstm_03 = types.stump,
			t_sky_flora_treepine7snowstm_04 = types.stump,
			t_sky_flora_treepine7snowstm_05 = types.stump,
			t_sky_flora_treepine7snowstm_06 = types.stump,
			t_sky_flora_treepine7stump_01   = types.stump,
			t_sky_flora_treepine7stump_02   = types.stump,
			t_sky_flora_treepine7stump_03   = types.stump,
			t_sky_flora_treepine7stump_04   = types.stump,
			t_sky_flora_treepine7stump_05   = types.stump,
			t_sky_flora_treepine7stump_06   = types.stump,

			-- Dead Trees
			  -- Cyrodiil
			t_cyr_floragc_treeburned_01  = types.deadTree,
			t_cyr_floragc_treeburned_02  = types.deadTree,
			t_cyr_floragc_treeburned_03  = types.deadTree,
			t_cyr_floragc_treeburned_04  = types.deadTree,
			t_cyr_floragc_treedead_01    = types.deadTree,
			t_cyr_floragc_treedead_02    = types.deadTree,
			t_cyr_floragc_treedead_03    = types.deadTree,
			  -- Hammerfell
			t_ham_floragm_treedead_01    = types.deadTree,
			t_ham_floragm_treedead_02    = types.deadTree,
			t_ham_floragm_treedead_03    = types.deadTree,
			t_ham_floragm_treedead_04    = types.deadTree,
			t_ham_floragm_treedead_05    = types.deadTree,
			t_ham_floragm_treedead_06    = types.deadTree,
			  -- Morrowind
			t_mw_flora_tree_burnt_01     = types.deadTree,
			t_mw_flora_tree_burnt_02     = types.deadTree,
			  -- Skyrim
			t_sky_flora_treepine6dead_01 = types.deadTree,
			t_sky_flora_treepine6dead_02 = types.deadTree,
			t_sky_flora_treepine6dead_03 = types.deadTree,
			t_sky_flora_treepine6dead_04 = types.deadTree,
			t_sky_flora_treepine6dead_05 = types.deadTree,

			-- Rocks
			  -- Cyrodiil
			t_cyr_cavegc_i_rock_01         = types.stoneSource,
			t_cyr_cavegc_i_rock_02         = types.stoneSource,
			t_cyr_cavegc_i_rock_03         = types.stoneSource,
			t_cyr_cavegc_i_rock_04         = types.stoneSource,
			t_cyr_cavegc_i_rock_05         = types.stoneSource,
			t_cyr_cavegc_i_rock_06         = types.stoneSource,
			t_cyr_cavegc_i_rock_07         = types.stoneSource,
			t_cyr_cavegc_i_rock_08         = types.stoneSource,
			t_cyr_cavegc_i_rock_09         = types.stoneSource,
			t_cyr_cavegc_i_rock_10         = types.stoneSource,
			t_cyr_cavegc_i_rock_11         = types.stoneSource,
			t_cyr_cavegc_i_rock_12         = types.stoneSource,
			t_cyr_cavegc_i_rock_13         = types.stoneSource,
			t_cyr_cavegc_i_rock_14         = types.stoneSource,
			t_cyr_cavegc_i_rock_15         = types.stoneSource,
			t_cyr_cavegc_i_rock_16         = types.stoneSource,
			t_cyr_cavegc_i_rock_17         = types.stoneSource,
			t_cyr_cavegc_i_stalagmite_07   = types.stoneSource,
			t_cyr_cavegc_i_stalagmite_08   = types.stoneSource,
			t_cyr_cavegc_i_stalagmite_09   = types.stoneSource,
			t_cyr_cavegc_i_stalagmite_10   = types.stoneSource,
			t_cyr_cavegc_i_stalagmite_11   = types.stoneSource,
			t_cyr_cavegc_i_stalagmite_12   = types.stoneSource,
			t_cyr_cavegc_i_stalagmite_13   = types.stoneSource,
			t_cyr_cavegc_i_stalagmite_14   = types.stoneSource,
			t_cyr_cavegc_i_stalagmite_15   = types.stoneSource,
			t_cyr_cavegc_i_stalagmite_16   = types.stoneSource,
			t_cyr_cavegc_i_stalagmite_17   = types.stoneSource,
			t_cyr_terrrockgh_cliffm_01     = types.stoneSource,
			t_cyr_terrrockgh_cliffm_02     = types.stoneSource,
			t_cyr_terrrockgh_cliffm_03     = types.stoneSource,
			t_cyr_terrrockgh_cliffm_04     = types.stoneSource,
			t_cyr_terrrockgh_cliffm_05     = types.stoneSource,
			t_cyr_terrrockgh_cliffm_06     = types.stoneSource,
			t_cyr_terrrockgh_cliffm_07     = types.stoneSource,
			t_cyr_terrrockch_rock_01       = types.stoneSource,
			t_cyr_terrrockch_rock_02       = types.stoneSource,
			t_cyr_terrrockch_rock_03       = types.stoneSource,
			t_cyr_terrrockch_rock_04       = types.stoneSource,
			t_cyr_terrrockch_rock_05       = types.stoneSource,
			t_cyr_terrrockch_rock_06       = types.stoneSource,
			t_cyr_terrrockch_rock_07       = types.stoneSource,
			t_cyr_terrrockch_rock_08       = types.stoneSource,
			t_cyr_terrrockch_rock_09       = types.stoneSource,
			t_cyr_terrrockch_rock_10       = types.stoneSource,
			t_cyr_terrrockch_rock_11       = types.stoneSource,
			t_cyr_terrrockch_rock_12       = types.stoneSource,
			t_cyr_terrrockch_rock_13       = types.stoneSource,
			t_cyr_terrrockch_rockgrp_01    = types.stoneSource,
			t_cyr_terrrockch_rockgrp_02    = types.stoneSource,
			t_cyr_terrrockch_rockgrp_03    = types.stoneSource,
			t_cyr_terrrockch_rockgrp_04    = types.stoneSource,
			t_cyr_terrrockch_rockgrp_05    = types.stoneSource,
			t_cyr_terrrockch_rockgrp_06    = types.stoneSource,
			t_cyr_terrrockchg_rock_01      = types.stoneSource,
			t_cyr_terrrockchg_rock_02      = types.stoneSource,
			t_cyr_terrrockchg_rock_03      = types.stoneSource,
			t_cyr_terrrockchg_rock_04      = types.stoneSource,
			t_cyr_terrrockchg_rockgrp_01   = types.stoneSource,
			t_cyr_terrrockchg_rockgrp_02   = types.stoneSource,
			t_cyr_terrrockchg_rockgrp_03   = types.stoneSource,
			t_cyr_terrrockchg_rockgrp_04   = types.stoneSource,
			t_cyr_terrrockchg_rockgrp_05   = types.stoneSource,
			t_cyr_terrrockchg_rockgrp_06   = types.stoneSource,
			t_cyr_terrrockgc_cliff_01      = types.stoneSource,
			t_cyr_terrrockgc_cliff_02      = types.stoneSource,
			t_cyr_terrrockgc_cliff_03      = types.stoneSource,
			t_cyr_terrrockgc_cliff_04      = types.stoneSource,
			t_cyr_terrrockgc_cliff_05      = types.stoneSource,
			t_cyr_terrrockgc_cliff_06      = types.stoneSource,
			t_cyr_terrrockgc_terredge_01   = types.stoneSource,
			t_cyr_terrrockgc_rock_01       = types.stoneSource,
			t_cyr_terrrockgc_rock_02       = types.stoneSource,
			t_cyr_terrrockgc_rock_03       = types.stoneSource,
			t_cyr_terrrockgc_rock_04       = types.stoneSource,
			t_cyr_terrrockgc_rock_05       = types.stoneSource,
			t_cyr_terrrockgc_rock_06       = types.stoneSource,
			t_cyr_terrrockgc_rock_07       = types.stoneSource,
			t_cyr_terrrockgc_rock_08       = types.stoneSource,
			t_cyr_terrrockgc_rock_09       = types.stoneSource,
			t_cyr_terrrockgc_rock_10       = types.stoneSource,
			t_cyr_terrrockgc_rock_11       = types.stoneSource,
			t_cyr_terrrockgc_rock_12       = types.stoneSource,
			t_cyr_terrrockgc_rock_13       = types.stoneSource,
			t_cyr_terrrockgc_rock_14       = types.stoneSource,
			t_cyr_terrrockgc_rock_15       = types.stoneSource,
			t_cyr_terrrockgc_rock_16       = types.stoneSource,
			t_cyr_terrrockgc_rock_17       = types.stoneSource,
			t_cyr_terrrockgc_rock_18       = types.stoneSource,
			t_cyr_terrrockgc_rock_19       = types.stoneSource,
			t_cyr_terrrockgc_rock_20       = types.stoneSource,
			t_cyr_terrrockgc_rock_21       = types.stoneSource,
			t_cyr_terrrockgc_rock_22       = types.stoneSource,
			t_cyr_terrrockgc_rock_23       = types.stoneSource,
			t_cyr_terrrockgc_rock_24       = types.stoneSource,
			t_cyr_terrrockgc_rock_25       = types.stoneSource,
			t_cyr_terrrockgc_rock_26       = types.stoneSource,
			t_cyr_terrrockgc_rock_27       = types.stoneSource,
			t_cyr_terrrockgc_rock_28       = types.stoneSource,
			t_cyr_terrrockgc_rock_29       = types.stoneSource,
			t_cyr_terrrockgc_rock_30       = types.stoneSource,
			t_cyr_terrrockgc_rock_31       = types.stoneSource,
			t_cyr_terrrockgc_rock_32       = types.stoneSource,
			t_cyr_terrrockgc_rock_33       = types.stoneSource,
			t_cyr_terrrockgc_rock_34       = types.stoneSource,
			t_cyr_terrrockgc_rockstair_01  = types.stoneSource,
			t_cyr_terrrockgh_cliff_01      = types.stoneSource,
			t_cyr_terrrockgh_cliff_02      = types.stoneSource,
			t_cyr_terrrockgh_cliff_03      = types.stoneSource,
			t_cyr_terrrockgh_cliff_04      = types.stoneSource,
			t_cyr_terrrockgh_cliff_05      = types.stoneSource,
			t_cyr_terrrockgh_cliff_06      = types.stoneSource,
			t_cyr_terrrockgh_edge_01       = types.stoneSource,
			t_cyr_terrrockgh_grass_01      = types.stoneSource,
			t_cyr_terrrockgh_mtcliff_02    = types.stoneSource,
			t_cyr_terrrockgh_mtpeak_01     = types.stoneSource,
			t_cyr_terrrockgh_rock_01       = types.stoneSource,
			t_cyr_terrrockgh_rock_02       = types.stoneSource,
			t_cyr_terrrockgh_rock_03       = types.stoneSource,
			t_cyr_terrrockgh_rock_04       = types.stoneSource,
			t_cyr_terrrockgh_rock_05       = types.stoneSource,
			t_cyr_terrrockgh_rock_06       = types.stoneSource,
			t_cyr_terrrockgh_rock_07       = types.stoneSource,
			t_cyr_terrrockgh_rock_08       = types.stoneSource,
			t_cyr_terrrockgh_rock_09       = types.stoneSource,
			t_cyr_terrrockgh_rock_10       = types.stoneSource,
			t_cyr_terrrockgh_rock_11       = types.stoneSource,
			t_cyr_terrrockgh_rock_12       = types.stoneSource,
			t_cyr_terrrockgh_rock_13       = types.stoneSource,
			t_cyr_terrrockgh_rock_14       = types.stoneSource,
			t_cyr_terrrockgh_rock_15       = types.stoneSource,
			t_cyr_terrrockgh_rock_16       = types.stoneSource,
			t_cyr_terrrockgh_rock_17       = types.stoneSource,
			t_cyr_terrrockgh_rock_18       = types.stoneSource,
			t_cyr_terrrockgh_rock_19       = types.stoneSource,
			t_cyr_terrrockgh_rock_20       = types.stoneSource,
			t_cyr_terrrockgh_rock_21       = types.stoneSource,
			t_cyr_terrrockgh_rock_22       = types.stoneSource,
			t_cyr_terrrockgh_rock_23       = types.stoneSource,
			t_cyr_terrrockgh_rock_24       = types.stoneSource,
			t_cyr_terrrockgh_rock_25       = types.stoneSource,
			t_cyr_terrrockgh_rock_26       = types.stoneSource,
			t_cyr_terrrockgh_rock_27       = types.stoneSource,
			t_cyr_terrrockgh_rock_28       = types.stoneSource,
			t_cyr_terrrockgh_rock_29       = types.stoneSource,
			t_cyr_terrrockgh_rock_30       = types.stoneSource,
			t_cyr_terrrockgh_rock_31       = types.stoneSource,
			t_cyr_terrrockgh_rock_32       = types.stoneSource,
			t_cyr_terrrockgh_rock_33       = types.stoneSource,
			t_cyr_terrrockgh_rocks_01      = types.stoneSource,
			t_cyr_terrrockgh_rocks_02      = types.stoneSource,
			t_cyr_terrrockgh_rocks_03      = types.stoneSource,
			t_cyr_terrrockgh_rocks_04      = types.stoneSource,
			t_cyr_terrrockgh_rocks_05      = types.stoneSource,
			t_cyr_terrrockgh_rocks_06      = types.stoneSource,
			t_cyr_terrrockgh_rocks_07      = types.stoneSource,
			t_cyr_terrrockgh_rocks_08      = types.stoneSource,
			t_cyr_terrrockgh_rocks_09      = types.stoneSource,
			t_cyr_terrrockgh_rocks_10      = types.stoneSource,
			t_cyr_terrrockkp_rock_01       = types.stoneSource,
			t_cyr_terrrockkp_rock_02       = types.stoneSource,
			t_cyr_terrrockkp_rock_03       = types.stoneSource,
			t_cyr_terrrockkp_rock_04       = types.stoneSource,
			t_cyr_terrrockkp_rock_05       = types.stoneSource,
			t_cyr_terrrockkp_rock_06       = types.stoneSource,
			t_cyr_terrrockkp_rock_07       = types.stoneSource,
			t_cyr_terrrockkp_rock_08       = types.stoneSource,
			t_cyr_terrrockkp_rock_09       = types.stoneSource,
			t_cyr_terrrockkp_rock_10       = types.stoneSource,
			t_cyr_terrrockkp_rock_11       = types.stoneSource,
			t_cyr_terrrockkp_rock_12       = types.stoneSource,
			t_cyr_terrrockkp_rockgrass1_01 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass1_02 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass1_03 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass1_04 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass1_05 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass1_06 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass1_07 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass1_08 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass1_09 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass1_10 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass2_01 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass2_02 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass2_03 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass2_04 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass2_05 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass2_06 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass2_07 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass2_08 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass2_09 = types.stoneSource,
			t_cyr_terrrockkp_rockgrass2_10 = types.stoneSource,
			t_cyr_terrrockkp_rockgrassd_01 = types.stoneSource,
			t_cyr_terrrockkp_rockgrassd_02 = types.stoneSource,
			t_cyr_terrrockkp_rockgrassd_03 = types.stoneSource,
			t_cyr_terrrockkp_rockgrassd_04 = types.stoneSource,
			t_cyr_terrrockkp_rockgrassd_05 = types.stoneSource,
			t_cyr_terrrockkp_rockgrassd_06 = types.stoneSource,
			t_cyr_terrrockkp_rockgrassd_07 = types.stoneSource,
			t_cyr_terrrockkp_rockgrassd_08 = types.stoneSource,
			t_cyr_terrrockkp_rockgrassd_09 = types.stoneSource,
			t_cyr_terrrockkp_rockgrassd_10 = types.stoneSource,
			t_cyr_terrrockkp_rocks_01      = types.stoneSource,
			t_cyr_terrrockkp_rocks_02      = types.stoneSource,
			t_cyr_terrrockkp_rocks_03      = types.stoneSource,
			t_cyr_terrrockkp_rocks_04      = types.stoneSource,
			t_cyr_terrrockch_mtcliff_01    = types.stoneSource,
			t_cyr_terrrockch_mtpeak_01     = types.stoneSource,
			t_cyr_terrrockch_rockquarry_01 = types.stoneSource,
			t_cyr_terrrockch_rockquarry_02 = types.stoneSource,

			t_sky_terrrockre_rockseawd_01 = types.stoneSource,
			t_sky_terrrockre_rockseawd_02 = types.stoneSource,
			t_sky_terrrockre_rockseawd_03 = types.stoneSource,
			t_sky_terrrockre_rockseawd_04 = types.stoneSource,
			t_sky_terrrockre_rockseawds_01 = types.stoneSource,
			t_sky_terrrockre_rockseawds_02 = types.stoneSource,
			t_sky_terrrockre_rockseawds_03 = types.stoneSource,
			t_sky_terrrockre_rockseawds_04 = types.stoneSource,
			t_sky_terrrockjm_boulder_01 = types.stoneSource,
			t_sky_terrrockjm_boulder_02 = types.stoneSource,
			t_sky_terrrockjm_boulder_03 = types.stoneSource,
			t_sky_terrrockjm_boulder_04 = types.stoneSource,
			t_sky_terrrockjm_boulder_05 = types.stoneSource,
			t_sky_terrrockjm_boulder_06 = types.stoneSource,
			t_sky_terrrockjm_boulder_07 = types.stoneSource,
			t_sky_terrrockjm_boulder_08 = types.stoneSource,
			t_sky_terrrockjm_boulder_09 = types.stoneSource,
			t_sky_terrrockjm_boulder_10 = types.stoneSource,
			t_sky_terrrockjm_boulder_11 = types.stoneSource,
			t_sky_terrrockem_boulder_01 = types.stoneSource,
			t_sky_terrrockem_boulder_02 = types.stoneSource,
			t_sky_terrrockem_boulder_03 = types.stoneSource,
			t_sky_terrrockem_boulder_04 = types.stoneSource,
			t_sky_terrrockem_boulder_05 = types.stoneSource,
			t_sky_terrrockem_boulder_06 = types.stoneSource,
			t_sky_terrrockem_boulder_07 = types.stoneSource,
			t_sky_terrrockem_boulder_08 = types.stoneSource,
			t_sky_terrrockem_boulder_09 = types.stoneSource,
			t_sky_terrrockre_boulder_01 = types.stoneSource,
			t_sky_terrrockre_boulder_02 = types.stoneSource,
			t_sky_terrrockre_boulder_03 = types.stoneSource,
			t_sky_terrrockre_boulder_04 = types.stoneSource,
			t_sky_terrrockre_boulder_05 = types.stoneSource,
			t_sky_terrrockre_boulder_06 = types.stoneSource,
			t_sky_terrrockre_boulder_07 = types.stoneSource,
			t_sky_terrrockre_boulder_08 = types.stoneSource,
			t_sky_terrrockre_boulder_09 = types.stoneSource,
			t_sky_terrrockre_boulder_10 = types.stoneSource,
			t_sky_terrrockre_boulder_11 = types.stoneSource,
			t_sky_terrrockreg_bouldergrs_01 = types.stoneSource,
			t_sky_terrrockreg_bouldergrs_02 = types.stoneSource,
			t_sky_terrrockreg_bouldergrs_03 = types.stoneSource,
			t_sky_terrrockreg_bouldergrs_04 = types.stoneSource,
			t_sky_terrrockreg_bouldergrs_05 = types.stoneSource,
			t_sky_terrrockreg_bouldergrs_06 = types.stoneSource,
			t_sky_terrrockreg_bouldergrs_07 = types.stoneSource,
			t_sky_terrrockreg_bouldergrs_08 = types.stoneSource,
			t_sky_terrrockreg_bouldergrs_09 = types.stoneSource,
			t_sky_terrrockreg_bouldergrs_10 = types.stoneSource,
			t_sky_terrrockre_boulderlvs_01 = types.stoneSource,
			t_sky_terrrockre_boulderlvs_02 = types.stoneSource,
			t_sky_terrrockre_boulderlvs_03 = types.stoneSource,
			t_sky_terrrockre_boulderlvs_04 = types.stoneSource,
			t_sky_terrrockre_boulderlvs_05 = types.stoneSource,
			t_sky_terrrockre_boulderlvs_06 = types.stoneSource,
			t_sky_terrrockre_boulderlvs_07 = types.stoneSource,
			t_sky_terrrockre_boulderlvs_08 = types.stoneSource,
			t_sky_terrrockre_boulderlvs_09 = types.stoneSource,
			t_sky_terrrockre_boulderlvs_10 = types.stoneSource,
			t_sky_terrrockwr_cliff_01 = types.stoneSource,
			t_sky_terrrockwrs_cliff_01a = types.stoneSource,
			t_sky_terrrockwrs_cliff_01b = types.stoneSource,
			t_sky_terrrockwrs_cliff_01c = types.stoneSource,
			t_sky_terrrockwr_cliff_02 = types.stoneSource,
			t_sky_terrrockwrs_cliff_02a = types.stoneSource,
			t_sky_terrrockwrs_cliff_02b = types.stoneSource,
			t_sky_terrrockwrs_cliff_02c = types.stoneSource,
			t_sky_terrrockre_clifflrg_01a = types.stoneSource,
			t_sky_terrrockre_clifflrg_01b = types.stoneSource,
			t_sky_terrrockre_clifflrg_02a = types.stoneSource,
			t_sky_terrrockre_clifflrg_02b = types.stoneSource,
			t_sky_terrrockre_clifflrg_02c = types.stoneSource,
			t_sky_terrrockre_clifflrg_02d = types.stoneSource,
			t_sky_terrrockre_clifflrg_02e = types.stoneSource,
			t_sky_terrrockre_clifflrg_03a = types.stoneSource,
			t_sky_terrrockre_clifflrg_03b = types.stoneSource,
			t_sky_terrrockre_clifflrg_04a = types.stoneSource,
			t_sky_terrrockre_clifflrg_04b = types.stoneSource,
			t_sky_terrrockre_clifflrg_05a = types.stoneSource,
			t_sky_terrrockre_clifflrg_05b = types.stoneSource,
			t_sky_terrrockre_clifflrg_06a = types.stoneSource,
			t_sky_terrrockre_clifflrg_06b = types.stoneSource,
			t_sky_terrrockre_clifflrg_07a = types.stoneSource,
			t_sky_terrrockre_clifflrg_07b = types.stoneSource,
			t_sky_terrrockre_clifflrg_08a = types.stoneSource,
			t_sky_terrrockre_clifflrg_08b = types.stoneSource,
			t_sky_terrrockre_clifflrg_09a = types.stoneSource,
			t_sky_terrrockre_clifflrg_09b = types.stoneSource,
			t_sky_terrrockre_clifflrg_10a = types.stoneSource,
			t_sky_terrrockre_clifflrg_10b = types.stoneSource,
			t_sky_terrrockre_clifflrg_11a = types.stoneSource,
			t_sky_terrrockre_clifflrg_11b = types.stoneSource,
			t_sky_terrrockre_clifflrg_12a = types.stoneSource,
			t_sky_terrrockre_clifflrg_12b = types.stoneSource,
			t_sky_terrrockre_clifflrg_13a = types.stoneSource,
			t_sky_terrrockre_clifflrg_13b = types.stoneSource,
			t_sky_terrrockre_clifflrg_14a = types.stoneSource,
			t_sky_terrrockre_clifflrg_15a = types.stoneSource,
			t_sky_terrrockre_clifflrg_15b = types.stoneSource,
			t_sky_terrrockre_clifflrg_15c = types.stoneSource,
			t_sky_terrrockre_cliffsml_01a = types.stoneSource,
			t_sky_terrrockre_cliffsml_01b = types.stoneSource,
			t_sky_terrrockre_cliffsml_02a = types.stoneSource,
			t_sky_terrrockre_cliffsml_02b = types.stoneSource,
			t_sky_terrrockre_cliffsml_02c = types.stoneSource,
			t_sky_terrrockre_cliffsml_02d = types.stoneSource,
			t_sky_terrrockre_cliffsml_02e = types.stoneSource,
			t_sky_terrrockre_cliffsml_03a = types.stoneSource,
			t_sky_terrrockre_cliffsml_03b = types.stoneSource,
			t_sky_terrrockre_cliffsml_04a = types.stoneSource,
			t_sky_terrrockre_cliffsml_04b = types.stoneSource,
			t_sky_terrrockre_cliffsml_05a = types.stoneSource,
			t_sky_terrrockre_cliffsml_05b = types.stoneSource,
			t_sky_terrrockre_cliffsml_06a = types.stoneSource,
			t_sky_terrrockre_cliffsml_06b = types.stoneSource,
			t_sky_terrrockre_cliffsml_07a = types.stoneSource,
			t_sky_terrrockre_cliffsml_07b = types.stoneSource,
			t_sky_terrrockre_cliffsml_08a = types.stoneSource,
			t_sky_terrrockre_cliffsml_08b = types.stoneSource,
			t_sky_terrrockre_cliffsml_09a = types.stoneSource,
			t_sky_terrrockre_cliffsml_09b = types.stoneSource,
			t_sky_terrrockre_cliffsml_10a = types.stoneSource,
			t_sky_terrrockre_cliffsml_10b = types.stoneSource,
			t_sky_terrrockre_cliffsml_11a = types.stoneSource,
			t_sky_terrrockre_cliffsml_11b = types.stoneSource,
			t_sky_terrrockre_cliffsml_12a = types.stoneSource,
			t_sky_terrrockre_cliffsml_12b = types.stoneSource,
			t_sky_terrrockre_cliffsml_13a = types.stoneSource,
			t_sky_terrrockre_cliffsml_13b = types.stoneSource,
			t_sky_terrrockre_cliffsml_14a = types.stoneSource,
			t_sky_terrrockre_cliffsml_15a = types.stoneSource,
			t_sky_terrrockre_cliffsml_15b = types.stoneSource,
			t_sky_terrrockre_cliffsml_15c = types.stoneSource,
			t_sky_terrrockre_terredgesn_01 = types.stoneSource,

			t_glb_terrice_rock_01 = types.stoneSource,
			t_glb_terrice_rock_02 = types.stoneSource,
			t_glb_terrice_rock_03 = types.stoneSource,
			t_glb_terrice_rock_04 = types.stoneSource,
			t_glb_terrice_rock_05 = types.stoneSource,
			t_glb_terrice_rock_06 = types.stoneSource,
			t_glb_terrice_rock_07 = types.stoneSource,
			t_glb_terrice_rock_08 = types.stoneSource,
			t_glb_terrice_rock_09 = types.stoneSource,
			t_glb_terrice_rock_10 = types.stoneSource,
			t_glb_terrice_rock_11 = types.stoneSource,
			t_glb_terrice_rock_12 = types.stoneSource,
			t_glb_terrice_rock_13 = types.stoneSource,
			t_glb_terrice_rock_14 = types.stoneSource,
			t_glb_terrice_rock_15 = types.stoneSource,
			t_glb_terrice_rock_16 = types.stoneSource,
			t_glb_terrice_rock_17 = types.stoneSource,
			t_glb_terrice_rock_18 = types.stoneSource,
			t_glb_terrice_rock_19 = types.stoneSource,
			t_glb_terrice_rock_20 = types.stoneSource,
			t_glb_terrice_rock_21 = types.stoneSource,
			t_glb_terrice_rock_22 = types.stoneSource,
			t_glb_terrice_rock_23 = types.stoneSource,
			t_glb_terrice_rock_24 = types.stoneSource,
			t_glb_terrice_rock_25 = types.stoneSource,
			t_glb_terrice_rock_26 = types.stoneSource,
			t_glb_terrice_rock_27 = types.stoneSource,
			t_glb_terrice_rock_28 = types.stoneSource,
			t_glb_terrice_rock_29 = types.stoneSource,
			t_glb_terrice_rock_30 = types.stoneSource,

			t_sky_terrrockre_mtcliff_01 = types.stoneSource,
			t_sky_terrrockre_mtcliff_02 = types.stoneSource,
			t_sky_terrrockjm_mtcliff_01 = types.stoneSource,
			t_sky_terrrockjm_mtcliff_02 = types.stoneSource,
			t_sky_terrrockjm_mtpeak_01 = types.stoneSource,
			t_sky_terrrockre_mtpeak_01 = types.stoneSource,
			t_sky_terrrockres_mtcliff_01 = types.stoneSource,
			t_sky_terrrockres_mtcliff_02 = types.stoneSource,
			t_sky_terrrockres_mtpeak_01 = types.stoneSource,
			t_sky_terrrockwr_ritualrocks_01 = types.stoneSource,
			t_sky_terrrockjm_ritualrocks_01 = types.stoneSource,
			t_sky_terrrockem_ritualrocks_01 = types.stoneSource,
			t_sky_terrrockre_ritualrocks_01 = types.stoneSource,
			t_sky_terrrockwr_rocksml_01 = types.stoneSource,
			t_sky_terrrockwrs_rocksml_01 = types.stoneSource,
			t_sky_terrrockwrs_rocksnw_01 = types.stoneSource,
			t_sky_terrrockwrs_rocksnw_02 = types.stoneSource,
			t_sky_terrrockwr_rocksml_02 = types.stoneSource,
			t_sky_terrrockwrs_rocksml_02 = types.stoneSource,
			t_sky_terrrockwr_rock_01 = types.stoneSource,
			t_sky_terrrockwrs_rock_01 = types.stoneSource,
			t_sky_terrrockwrs_rocksnw_03 = types.stoneSource,
			t_sky_terrrockwr_rock_02 = types.stoneSource,
			t_sky_terrrockwrs_rock_02 = types.stoneSource,
			t_sky_terrrockwrs_rocksnw_04 = types.stoneSource,
			t_sky_terrrockwr_rock_03 = types.stoneSource,
			t_sky_terrrockwrs_rock_03 = types.stoneSource,
			t_sky_terrrockwrs_rocksnw_05 = types.stoneSource,
			t_sky_terrrockwr_rock_04 = types.stoneSource,
			t_sky_terrrockwrs_rock_04 = types.stoneSource,
			t_sky_terrrockwrs_rocksnw_06 = types.stoneSource,
			t_sky_terrrockwr_rock_05 = types.stoneSource,
			t_sky_terrrockwrs_rock_05 = types.stoneSource,
			t_sky_terrrockwrs_rocksnw_07 = types.stoneSource,
			t_sky_terrrockwr_rock_06 = types.stoneSource,
			t_sky_terrrockwrs_rock_06 = types.stoneSource,
			t_sky_terrrockwrs_rocksnw_08 = types.stoneSource,
			t_sky_terrrockwr_rock_07 = types.stoneSource,
			t_sky_terrrockwrs_rock_07 = types.stoneSource,
			t_sky_terrrockwrs_rocksnw_09 = types.stoneSource,
			t_sky_terrrockwr_rock_08 = types.stoneSource,
			t_sky_terrrockwrs_rock_08a = types.stoneSource,
			t_sky_terrrockwrs_rock_08b = types.stoneSource,
			t_sky_terrrockwrs_rocksnw_10 = types.stoneSource,
			t_sky_terrrockwr_rock_09 = types.stoneSource,
			t_sky_terrrockwrs_rock_09a = types.stoneSource,
			t_sky_terrrockwrs_rock_09b = types.stoneSource,
			t_sky_terrrockwrs_rocksnw_11 = types.stoneSource,
			t_sky_terrrockwr_rock_10 = types.stoneSource,
			t_sky_terrrockwrs_rock_10a = types.stoneSource,
			t_sky_terrrockwrs_rock_10b = types.stoneSource,
			t_sky_terrrockwrs_rocksnw_12 = types.stoneSource,
			t_sky_terrrockjm_rocksml_01 = types.stoneSource,
			t_sky_terrrockjm_rocksml_02 = types.stoneSource,
			t_sky_terrrockjm_rocksml_03 = types.stoneSource,
			t_sky_terrrockjm_rocksml_04 = types.stoneSource,
			t_sky_terrrockjm_rocksml_05 = types.stoneSource,
			t_sky_terrrockjm_rocksml_06 = types.stoneSource,
			t_sky_terrrockjm_rocksml_07 = types.stoneSource,
			t_sky_terrrockjm_rocksml_08 = types.stoneSource,
			t_sky_terrrockjm_rocksml_09 = types.stoneSource,
			t_sky_terrrockjm_rocksml_10 = types.stoneSource,
			t_sky_terrrockjm_rocksml_11 = types.stoneSource,
			t_sky_terrrockjm_rocksml_12 = types.stoneSource,
			t_sky_terrrockjm_rock_01 = types.stoneSource,
			t_sky_terrrockjm_rock_02 = types.stoneSource,
			t_sky_terrrockjm_rock_03 = types.stoneSource,
			t_sky_terrrockjm_rock_04 = types.stoneSource,
			t_sky_terrrockjm_rock_05 = types.stoneSource,
			t_sky_terrrockjm_rock_06 = types.stoneSource,
			t_sky_terrrockjm_rock_07 = types.stoneSource,
			t_sky_terrrockjm_rock_08 = types.stoneSource,
			t_sky_terrrockjm_rock_09 = types.stoneSource,
			t_sky_terrrockjm_rock_10 = types.stoneSource,
			t_sky_terrrockjm_rock_11 = types.stoneSource,
			t_sky_terrrockjm_rock_12 = types.stoneSource,
			t_sky_terrrockjm_rock_13 = types.stoneSource,
			t_sky_terrrockjm_rock_14 = types.stoneSource,
			t_sky_terrrockjm_rock_15 = types.stoneSource,
			t_sky_terrrockjm_rock_16 = types.stoneSource,
			t_sky_terrrockjm_rock_17 = types.stoneSource,
			t_sky_terrrockjm_rock_18 = types.stoneSource,
			t_sky_terrrockem_rocksml_01 = types.stoneSource,
			t_sky_terrrockem_rockflt_01 = types.stoneSource,
			t_sky_terrrockem_rockflt_02 = types.stoneSource,
			t_sky_terrrockem_rockpky_01 = types.stoneSource,
			t_sky_terrrockem_rockpky_02 = types.stoneSource,
			t_sky_terrrockem_rockpky_03 = types.stoneSource,
			t_sky_terrrockem_rockpky_04 = types.stoneSource,
			t_sky_terrrockem_rockpky_05 = types.stoneSource,
			t_sky_terrrockem_rockpky_06 = types.stoneSource,
			t_sky_terrrockem_rockpky_07 = types.stoneSource,
			t_sky_terrrockem_rockpky_08 = types.stoneSource,
			t_sky_terrrockem_rockpky_09 = types.stoneSource,
			t_sky_terrrockem_rockpky_10 = types.stoneSource,
			t_sky_terrrockem_rockpky_11 = types.stoneSource,
			t_sky_terrrockem_rockflt_03 = types.stoneSource,
			t_sky_terrrockem_rockflt_04 = types.stoneSource,
			t_sky_terrrockem_rockpky_12 = types.stoneSource,
			t_sky_terrrockem_rockflt_05 = types.stoneSource,
			t_sky_terrrockem_rockflt_06 = types.stoneSource,
			t_sky_terrrockem_rockflt_07 = types.stoneSource,
			t_sky_terrrockem_rockpky_13 = types.stoneSource,
			t_sky_terrrockem_rockflt_08 = types.stoneSource,
			t_sky_terrrockem_rockflt_09 = types.stoneSource,
			t_sky_terrrockem_rockflt_10 = types.stoneSource,
			t_sky_terrrockem_rock_01 = types.stoneSource,
			t_sky_terrrockem_rock_02 = types.stoneSource,
			t_sky_terrrockem_rock_03 = types.stoneSource,
			t_sky_terrrockem_rock_04 = types.stoneSource,
			t_sky_terrrockem_rock_05 = types.stoneSource,
			t_sky_terrrockem_rock_06 = types.stoneSource,
			t_sky_terrrockem_rocksml_02 = types.stoneSource,
			t_sky_terrrockem_rock_07 = types.stoneSource,
			t_sky_terrrockem_rocksml_03 = types.stoneSource,
			t_sky_terrrockem_rocksml_04 = types.stoneSource,
			t_sky_terrrockem_rock_08 = types.stoneSource,
			t_sky_terrrockem_rock_09 = types.stoneSource,
			t_sky_terrrockem_rock_10 = types.stoneSource,
			t_sky_terrrockem_rock_11 = types.stoneSource,
			t_sky_terrrockem_rock_12 = types.stoneSource,
			t_sky_terrrockem_rock_13 = types.stoneSource,
			t_sky_terrrockem_rocksml_05 = types.stoneSource,
			t_sky_terrrockem_rocksml_06 = types.stoneSource,
			t_sky_terrrockem_rocksml_07 = types.stoneSource,
			t_sky_terrrockem_rocksml_08 = types.stoneSource,
			t_sky_terrrockem_rocksml_09 = types.stoneSource,
			t_sky_terrrockem_rocksml_10 = types.stoneSource,
			t_sky_terrrockem_rock_14 = types.stoneSource,
			t_sky_terrrockem_rock_15 = types.stoneSource,
			t_sky_terrrockem_rock_16 = types.stoneSource,
			t_sky_terrrockem_rock_17 = types.stoneSource,
			t_sky_terrrockem_rocksml_11 = types.stoneSource,
			t_sky_terrrockem_rock_18 = types.stoneSource,
			t_sky_terrrockem_rock_19 = types.stoneSource,
			t_sky_terrrockem_rock_20 = types.stoneSource,
			t_sky_terrrockre_rockpky_01 = types.stoneSource,
			t_sky_terrrockre_rockflt_01 = types.stoneSource,
			t_sky_terrrockre_rockflt_02 = types.stoneSource,
			t_sky_terrrockre_rockpky_02 = types.stoneSource,
			t_sky_terrrockre_rock_01 = types.stoneSource,
			t_sky_terrrockre_rockpky_03 = types.stoneSource,
			t_sky_terrrockre_rockpky_04 = types.stoneSource,
			t_sky_terrrockre_rockpky_05 = types.stoneSource,
			t_sky_terrrockre_rockpky_06 = types.stoneSource,
			t_sky_terrrockre_rocksml_01 = types.stoneSource,
			t_sky_terrrockre_rockpky_07 = types.stoneSource,
			t_sky_terrrockre_rockpky_08 = types.stoneSource,
			t_sky_terrrockre_rockflt_03 = types.stoneSource,
			t_sky_terrrockre_rockpky_09 = types.stoneSource,
			t_sky_terrrockre_rockpky_10 = types.stoneSource,
			t_sky_terrrockre_rockflt_04 = types.stoneSource,
			t_sky_terrrockre_rockflt_05 = types.stoneSource,
			t_sky_terrrockre_rockpky_11 = types.stoneSource,
			t_sky_terrrockre_rockflt_06 = types.stoneSource,
			t_sky_terrrockre_rockflt_07 = types.stoneSource,
			t_sky_terrrockre_rockpky_12 = types.stoneSource,
			t_sky_terrrockre_rockflt_08 = types.stoneSource,
			t_sky_terrrockre_rockflt_09 = types.stoneSource,
			t_sky_terrrockre_rockflt_10 = types.stoneSource,
			t_sky_terrrockre_rockpky_13 = types.stoneSource,
			t_sky_terrrockre_rockarc_04 = types.stoneSource,
			t_sky_terrrockre_rock_02 = types.stoneSource,
			t_sky_terrrockre_rockpky_14 = types.stoneSource,
			t_sky_terrrockre_rockflt_11 = types.stoneSource,
			t_sky_terrrockre_rockflt_12 = types.stoneSource,
			t_sky_terrrockre_rockflt_13 = types.stoneSource,
			t_sky_terrrockre_rockpky_15 = types.stoneSource,
			t_sky_terrrockre_rockflt_14 = types.stoneSource,
			t_sky_terrrockre_rocklrg_01 = types.stoneSource,
			t_sky_terrrockre_rock_03 = types.stoneSource,
			t_sky_terrrockre_rock_04 = types.stoneSource,
			t_sky_terrrockre_rock_18 = types.stoneSource,
			t_sky_terrrockre_rock_05 = types.stoneSource,
			t_sky_terrrockre_rock_06 = types.stoneSource,
			t_sky_terrrockre_rocklrg_02 = types.stoneSource,
			t_sky_terrrockre_rocklrg_03 = types.stoneSource,
			t_sky_terrrockre_rock_07 = types.stoneSource,
			t_sky_terrrockre_rock_08 = types.stoneSource,
			t_sky_terrrockre_rock_09 = types.stoneSource,
			t_sky_terrrockre_rock_10 = types.stoneSource,
			t_sky_terrrockre_rocksml_02 = types.stoneSource,
			t_sky_terrrockre_rocksml_03 = types.stoneSource,
			t_sky_terrrockre_rocksml_04 = types.stoneSource,
			t_sky_terrrockre_rocksml_05 = types.stoneSource,
			t_sky_terrrockre_rocksml_06 = types.stoneSource,
			t_sky_terrrockre_rocksml_07 = types.stoneSource,
			t_sky_terrrockre_rockpky_16 = types.stoneSource,
			t_sky_terrrockre_rock_11 = types.stoneSource,
			t_sky_terrrockre_rocksml_08 = types.stoneSource,
			t_sky_terrrockre_rock_12 = types.stoneSource,
			t_sky_terrrockre_rock_13 = types.stoneSource,
			t_sky_terrrockre_rock_14 = types.stoneSource,
			t_sky_terrrockre_rocksml_09 = types.stoneSource,
			t_sky_terrrockre_rocksml_10 = types.stoneSource,
			t_sky_terrrockre_rocksml_11 = types.stoneSource,
			t_sky_terrrockre_rocksml_12 = types.stoneSource,
			t_sky_terrrockre_rock_15 = types.stoneSource,
			t_sky_terrrockre_rock_16 = types.stoneSource,
			t_sky_terrrockre_rock_17 = types.stoneSource,
			t_sky_terrrockre_rock_19 = types.stoneSource,
			t_sky_terrrockre_rockpky_17 = types.stoneSource,
			t_sky_terrrockre_rockpky_18 = types.stoneSource,
			t_sky_terrrockre_rockarc_01 = types.stoneSource,
			t_sky_terrrockre_rockarc_05 = types.stoneSource,
			t_sky_terrrockre_rocklrg_04 = types.stoneSource,
			t_sky_terrrockre_rocklrg_05 = types.stoneSource,
			t_sky_terrrockre_rockarc_06 = types.stoneSource,
			t_sky_terrrockre_rockarc_07 = types.stoneSource,
			t_sky_terrrockre_rocksml_13 = types.stoneSource,
			t_sky_terrrockre_rocksml_14 = types.stoneSource,
			t_sky_terrrockre_rocksml_15 = types.stoneSource,
			t_sky_terrrockre_rock_20 = types.stoneSource,
			t_sky_terrrockre_rock_21 = types.stoneSource,
			t_sky_terrrockre_rock_22 = types.stoneSource,
			t_sky_terrrockre_rocklrg_06 = types.stoneSource,
			t_sky_terrrockre_rocklrg_07 = types.stoneSource,
			t_sky_terrrockre_rock_23 = types.stoneSource,
			t_sky_terrrockre_rocklrg_08 = types.stoneSource,
			t_sky_terrrockre_rocklrg_09 = types.stoneSource,
			t_sky_terrrockre_rocksml_16 = types.stoneSource,
			t_sky_terrrockre_rocksml_17 = types.stoneSource,
			t_sky_terrrockre_rock_24 = types.stoneSource,
			t_sky_terrrockre_rockarc_02 = types.stoneSource,
			t_sky_terrrockre_rockarc_03 = types.stoneSource,
			t_sky_terrrockre_rocksml_18 = types.stoneSource,
			t_sky_terrrockre_rocksml_19 = types.stoneSource,
			t_sky_terrrockre_rock_25 = types.stoneSource,
			t_sky_terrrockre_rocksml_20 = types.stoneSource,
			t_sky_terrrockre_rock_26 = types.stoneSource,
			t_sky_terrrockre_rock_27 = types.stoneSource,
			t_sky_terrrockre_rockarc_08 = types.stoneSource,
			t_sky_terrrockre_rockarc_09 = types.stoneSource,
			t_sky_terrrockre_rocklrg_10 = types.stoneSource,
			t_sky_terrrockre_rocklrg_11 = types.stoneSource,
			t_sky_terrrockre_rocklrg_12 = types.stoneSource,
			t_sky_terrrockre_rocklrg_13 = types.stoneSource,
			t_sky_terrrockre_rockflt_15 = types.stoneSource,
			t_sky_terrrockre_rockflt_16 = types.stoneSource,
			t_sky_terrrockre_rockflt_17 = types.stoneSource,
			t_sky_terrrockre_rockflt_18 = types.stoneSource,
			t_sky_terrrockre_rocklrg_14 = types.stoneSource,
			t_sky_terrrockre_mtcliff_03 = types.stoneSource,
			t_sky_terrrockre_rocklrg_15 = types.stoneSource,
			t_sky_terrrockre_rocklrg_16 = types.stoneSource,
			t_sky_terrrockre_rock_28 = types.stoneSource,
			t_sky_terrrockre_rock_29 = types.stoneSource,
			t_sky_terrrockre_rock_32 = types.stoneSource,
			t_sky_terrrockre_rock_33 = types.stoneSource,
			t_sky_terrrockre_rock_34 = types.stoneSource,
			t_sky_terrrockre_rocklrg_17 = types.stoneSource,
			t_sky_terrrockre_rock_35 = types.stoneSource,
			t_sky_terrrockre_rock_36 = types.stoneSource,
			t_sky_terrrockre_rocklrg_18 = types.stoneSource,
			t_sky_terrrockre_rocklrg_19 = types.stoneSource,
			t_sky_terrrockre_rock_30 = types.stoneSource,
			t_sky_terrrockre_rock_31 = types.stoneSource,
			t_sky_terrrockreg_rockpky_01 = types.stoneSource,
			t_sky_terrrockreg_rock_01 = types.stoneSource,
			t_sky_terrrockreg_rock_02 = types.stoneSource,
			t_sky_terrrockreg_rockpky_02 = types.stoneSource,
			t_sky_terrrockreg_rockpky_03 = types.stoneSource,
			t_sky_terrrockreg_rockpky_04 = types.stoneSource,
			t_sky_terrrockreg_rockpky_05 = types.stoneSource,
			t_sky_terrrockreg_rockflt_01 = types.stoneSource,
			t_sky_terrrockreg_rockflt_02 = types.stoneSource,
			t_sky_terrrockreg_rockflt_03 = types.stoneSource,
			t_sky_terrrockreg_rockflt_04 = types.stoneSource,
			t_sky_terrrockreg_rockflt_05 = types.stoneSource,
			t_sky_terrrockreg_rock_03 = types.stoneSource,
			t_sky_terrrockreg_rock_04 = types.stoneSource,
			t_sky_terrrockreg_rocklrg_01 = types.stoneSource,
			t_sky_terrrockreg_rock_05 = types.stoneSource,
			t_sky_terrrockreg_rock_06 = types.stoneSource,
			t_sky_terrrockreg_rocksml_01 = types.stoneSource,
			t_sky_terrrockreg_rocksml_02 = types.stoneSource,
			t_sky_terrrockreg_rocksml_03 = types.stoneSource,
			t_sky_terrrockreg_rock_07 = types.stoneSource,
			t_sky_terrrockreg_rock_08 = types.stoneSource,
			t_sky_terrrockreg_rock_09 = types.stoneSource,
			t_sky_terrrockreg_rocksml_04 = types.stoneSource,
			t_sky_terrrockreg_rocksml_05 = types.stoneSource,
			t_sky_terrrockreg_rocksml_07 = types.stoneSource,
			t_sky_terrrockreg_rock_10 = types.stoneSource,
			t_sky_terrrockreg_rock_11 = types.stoneSource,
			t_sky_terrrockreg_rocksml_06 = types.stoneSource,
			t_sky_terrrockreg_rock_12 = types.stoneSource,
			t_sky_terrrockreg_rocksml_08 = types.stoneSource,
			t_sky_terrrockreg_rock_13 = types.stoneSource,
			t_sky_terrrockreg_rocklrg_02 = types.stoneSource,
			t_sky_terrrockreg_rockflt_06 = types.stoneSource,
			t_sky_terrrockreg_rockflt_07 = types.stoneSource,
			t_sky_terrrockreg_rockflt_08 = types.stoneSource,
			t_sky_terrrockreg_rockflt_09 = types.stoneSource,
			t_sky_terrrockreg_rockarc_01 = types.stoneSource,
			t_sky_terrrockreg_rocklrg_03 = types.stoneSource,
			t_ham_terrrockre_rock_01 = types.stoneSource,
			t_ham_terrrockre_rock_02 = types.stoneSource,
			t_ham_terrrockre_rock_03 = types.stoneSource,
			t_ham_terrrockre_rock_04 = types.stoneSource,
			t_ham_terrrockre_rock_05 = types.stoneSource,
			t_ham_terrrockre_rock_06 = types.stoneSource,
			t_ham_terrrockre_rock_07 = types.stoneSource,
			t_ham_terrrockre_rock_08 = types.stoneSource,
			t_ham_terrrockre_rock_09 = types.stoneSource,
			t_ham_terrrockre_rock_10 = types.stoneSource,
			t_ham_terrrockre_rock_11 = types.stoneSource,
			t_ham_terrrockre_rock_12 = types.stoneSource,
			t_ham_terrrockre_rock_13 = types.stoneSource,
			t_ham_terrrockre_rock_14 = types.stoneSource,
			t_ham_terrrockre_rock_15 = types.stoneSource,
			t_ham_terrrockre_rock_16 = types.stoneSource,
			t_ham_terrrockre_rock_17 = types.stoneSource,
			t_ham_terrrockre_rock_18 = types.stoneSource,
			t_ham_terrrockre_rock_19 = types.stoneSource,
			t_ham_terrrockre_rock_20 = types.stoneSource,
			t_ham_terrrockre_rock_21 = types.stoneSource,
			t_ham_terrrockre_rock_22 = types.stoneSource,
			t_sky_terrrockre_rocklvs_01 = types.stoneSource,
			t_sky_terrrockre_rocklvs_02 = types.stoneSource,
			t_sky_terrrockre_rocklvs_03 = types.stoneSource,
			t_sky_terrrockre_rocklvs_04 = types.stoneSource,
			t_sky_terrrockre_rocklvs_05 = types.stoneSource,
			t_sky_terrrockre_rocklvs_06 = types.stoneSource,
			t_sky_terrrockre_rocklvs_07 = types.stoneSource,
			t_sky_terrrockre_rocklvs_08 = types.stoneSource,
			t_sky_terrrockre_rocklvs_09 = types.stoneSource,
			t_sky_terrrockre_rocklvs_10 = types.stoneSource,
			t_sky_terrrockre_rocklvs_11 = types.stoneSource,
			t_sky_terrrockre_rocklvs_12 = types.stoneSource,
			t_sky_terrrockre_rocklvs_13 = types.stoneSource,
			t_sky_terrrockre_rocklvs_14 = types.stoneSource,
			t_sky_terrrockre_rocklvs_15 = types.stoneSource,
			t_sky_terrrockre_rocklvs_16 = types.stoneSource,
			t_sky_terrrockre_rocklvs_17 = types.stoneSource,
			t_sky_terrrockre_rocklvs_18 = types.stoneSource,
			t_sky_terrrockre_rocklvs_19 = types.stoneSource,
			t_sky_terrrockre_rocklvs_20 = types.stoneSource,
			t_sky_terrrockre_rocklvs_21 = types.stoneSource,
			t_sky_terrrockre_rocklvs_22 = types.stoneSource,
			t_sky_terrrockre_rockpin_01 = types.stoneSource,
			t_sky_terrrockre_rockpin_02 = types.stoneSource,
			t_sky_terrrockre_rockpin_03 = types.stoneSource,
			t_sky_terrrockre_rockpin_04 = types.stoneSource,
			t_sky_terrrockre_rockpin_05 = types.stoneSource,
			t_sky_terrrockre_rockpin_06 = types.stoneSource,
			t_sky_terrrockre_rockpin_07 = types.stoneSource,
			t_sky_terrrockre_rockpin_08 = types.stoneSource,
			t_sky_terrrockre_rockpin_09 = types.stoneSource,
			t_sky_terrrockre_rockpin_10 = types.stoneSource,
			t_sky_terrrockre_rockpin_11 = types.stoneSource,
			t_sky_terrrockre_rockpin_12 = types.stoneSource,
			t_sky_terrrockre_rockpin_13 = types.stoneSource,
			t_sky_terrrockre_rockpin_14 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_01 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_02 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_03 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_04 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_05 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_06 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_07 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_08 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_09 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_10 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_11 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_12 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_13 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_14 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_15 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_16 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_17 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_18 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_19 = types.stoneSource,
			t_sky_terrrockjm_rocksnw_20 = types.stoneSource,
			t_sky_terrrockem_rocksnw_01 = types.stoneSource,
			t_sky_terrrockem_rocksnw_02 = types.stoneSource,
			t_sky_terrrockem_rocksnw_03 = types.stoneSource,
			t_sky_terrrockem_rocksnw_04 = types.stoneSource,
			t_sky_terrrockem_rocksnw_05 = types.stoneSource,
			t_sky_terrrockem_rocksnw_06 = types.stoneSource,
			t_sky_terrrockem_rocksnw_07 = types.stoneSource,
			t_sky_terrrockem_rocksnw_08 = types.stoneSource,
			t_sky_terrrockem_rocksnw_09 = types.stoneSource,
			t_sky_terrrockem_rocksnw_10 = types.stoneSource,
			t_sky_terrrockem_rocksnw_12 = types.stoneSource,
			t_sky_terrrockem_rocksnw_13 = types.stoneSource,
			t_sky_terrrockem_rocksnw_14 = types.stoneSource,
			t_sky_terrrockem_rocksnw_15 = types.stoneSource,
			t_sky_terrrockem_rocksnw_16 = types.stoneSource,
			t_sky_terrrockem_rocksnw_17 = types.stoneSource,
			t_sky_terrrockem_rocksnw_18 = types.stoneSource,
			t_sky_terrrockem_rocksnw_19 = types.stoneSource,
			t_sky_terrrockem_rocksnw_20 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_01 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_02 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_03 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_04 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_05 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_06 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_07 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_08 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_09 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_10 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_11 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_12 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_13 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_14 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_15 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_16 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_17 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_18 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_19 = types.stoneSource,
			t_sky_terrrockjms_rocksnw_20 = types.stoneSource,
			t_sky_terrrockres_rocksnw_01 = types.stoneSource,
			t_sky_terrrockres_rocksnw_02 = types.stoneSource,
			t_sky_terrrockres_rocksnw_03 = types.stoneSource,
			t_sky_terrrockres_rocksnw_04 = types.stoneSource,
			t_sky_terrrockres_rocksnw_05 = types.stoneSource,
			t_sky_terrrockres_rocksnw_06 = types.stoneSource,
			t_sky_terrrockres_rocksnw_07 = types.stoneSource,
			t_sky_terrrockres_rocksnw_08 = types.stoneSource,
			t_sky_terrrockres_rocksnw_09 = types.stoneSource,
			t_sky_terrrockres_rocksnw_10 = types.stoneSource,
			t_sky_terrrockres_rocksnw_11 = types.stoneSource,
			t_sky_terrrockres_rocksnw_12 = types.stoneSource,
			t_sky_terrrockres_rocksnw_13 = types.stoneSource,
			t_sky_terrrockres_rocksnw_14 = types.stoneSource,
			t_sky_terrrockres_rocksnw_15 = types.stoneSource,
			t_sky_terrrockres_rocksnw_16 = types.stoneSource,
			t_sky_terrrockres_rocksnw_17 = types.stoneSource,
			t_sky_terrrockres_rocksnw_18 = types.stoneSource,
			t_sky_terrrockres_rocksnw_19 = types.stoneSource,
			t_sky_terrrockres_rocksnw_20 = types.stoneSource,
			t_sky_terrrockres_rocksnw_21 = types.stoneSource,
			t_sky_terrrockres_rocksnw_22 = types.stoneSource,
			t_sky_terrrockres_rocksnw_23 = types.stoneSource,
			t_sky_terrrockres_rocksnw_24 = types.stoneSource,
			t_sky_terrrockres_rocksnw_25 = types.stoneSource,
			t_sky_terrrockres_rocksnw_26 = types.stoneSource,
			t_sky_terrrockres_rocksnw_27 = types.stoneSource,
			t_sky_terrrockres_rocksnw_28 = types.stoneSource,
			t_sky_terrrockres_rocksnw_29 = types.stoneSource,
			t_sky_terrrockres_rocksnw_30 = types.stoneSource,
			t_sky_terrrockres_rocksnw_31 = types.stoneSource,
			t_sky_terrrockres_rocksnw_32 = types.stoneSource,
			t_sky_terrrockres_rocksnw_33 = types.stoneSource,
			t_sky_terrrockres_rocksnw_34 = types.stoneSource,
			t_sky_terrrockres_rocksnw_35 = types.stoneSource,
			t_sky_terrrockres_rocksnw_36 = types.stoneSource,
			t_sky_terrrockres_rocksnw_37 = types.stoneSource,
			t_sky_terrrockres_rocksnw_38 = types.stoneSource,
			t_sky_terrrockres_rocksnw_39 = types.stoneSource,
			t_sky_terrrockres_rocksnw_40 = types.stoneSource,
			t_sky_terrrockres_rocksnw_41 = types.stoneSource,
			t_sky_terrrockres_rocksnw_42 = types.stoneSource,
			t_sky_terrrockres_rocksnw_43 = types.stoneSource,
			t_sky_terrrockres_rocksnw_44 = types.stoneSource,
			t_sky_terrrockres_rocksnw_45 = types.stoneSource,
			t_sky_terrrockres_rocksnw_46 = types.stoneSource,
			t_sky_terrrockres_rocksnw_47 = types.stoneSource,
			t_sky_terrrockres_rocksnw_48 = types.stoneSource,
			t_sky_terrrockres_rocksnw_52 = types.stoneSource,
			t_sky_terrrockres_rocksnw_53 = types.stoneSource,
			t_sky_terrrockres_rocksnw_54 = types.stoneSource,
			t_sky_terrrockres_rocksnw_55 = types.stoneSource,
			t_sky_terrrockres_rocksnw_56 = types.stoneSource,
			t_sky_terrrockres_rocksnw_57 = types.stoneSource,
			t_sky_terrrockres_rocksnw_58 = types.stoneSource,
			t_sky_terrrockres_rocksnw_59 = types.stoneSource,
			t_sky_terrrockres_rocksnw_60 = types.stoneSource,
			t_sky_terrrockres_rocksnw_61 = types.stoneSource,
			t_sky_terrrockres_rocksnw_62 = types.stoneSource,
			t_sky_terrrockres_rocksnw_63 = types.stoneSource,
			t_sky_terrrockres_rocksnw_64 = types.stoneSource,
			t_sky_terrrockres_rocksnw_65 = types.stoneSource,
			t_sky_terrrockjm_rockgrp_01 = types.stoneSource,
			t_sky_terrrockjm_rockgrp_02 = types.stoneSource,
			t_sky_terrrockjm_rockgrp_03 = types.stoneSource,
			t_sky_terrrockjm_rockgrp_04 = types.stoneSource,
			t_sky_terrrockjm_rockgrp_05 = types.stoneSource,
			t_sky_terrrockjm_rockgrp_06 = types.stoneSource,
			t_sky_terrrockjm_rockgrp_07 = types.stoneSource,
			t_sky_terrrockem_rockgrp_01 = types.stoneSource,
			t_sky_terrrockre_rockgrp_01 = types.stoneSource,
			t_sky_terrrockre_rockgrp_02 = types.stoneSource,
			t_sky_terrrockre_rockgrp_03 = types.stoneSource,
			t_sky_terrrockre_rockgrp_04 = types.stoneSource,
			t_sky_terrrockreg_rockgrp_01 = types.stoneSource,
			t_sky_terrrockreg_rockgrp_02 = types.stoneSource,
			t_sky_terrrockreg_rockgrp_03 = types.stoneSource,
			t_sky_terrrockreg_rockgrp_04 = types.stoneSource,

			t_ham_terrrockre_rockgrp_01 = types.stoneSource,
			t_ham_terrrockre_rockgrp_02 = types.stoneSource,
			t_ham_terrrockre_rockgrp_03 = types.stoneSource,
			t_ham_terrrockre_rockgrp_04 = types.stoneSource,
			t_ham_terrrockre_rockgrp_05 = types.stoneSource,
			t_ham_terrrockre_rockgrp_06 = types.stoneSource,
			t_ham_terrrockre_rockgrp_07 = types.stoneSource,
			t_ham_terrrockre_rockgrp_08 = types.stoneSource,
			t_ham_terrrockre_rockgrp_09 = types.stoneSource,
			t_ham_terrrockre_rockgrp_10 = types.stoneSource,

			t_sky_terrrockre_rockseaw_01 = types.stoneSource,
			t_sky_terrrockre_rockseaw_02 = types.stoneSource,
			t_sky_terrrockre_rockseaw_03 = types.stoneSource,
			t_sky_terrrockre_rockseaw_04 = types.stoneSource,
			t_sky_terrrockre_rockseaw_05 = types.stoneSource,
			t_sky_terrrockre_rockseaw_06 = types.stoneSource,
			t_sky_terrrockre_rockseaw_07 = types.stoneSource,
			t_sky_terrrockre_rockseaw_08 = types.stoneSource,
			t_sky_terrrockre_rockseaw_09 = types.stoneSource,
			t_sky_terrrockre_rockseaw_10 = types.stoneSource,
			t_sky_terrrockre_rockseaw_11 = types.stoneSource,
			t_sky_terrrockre_rockseaws_01 = types.stoneSource,
			t_sky_terrrockre_rockseaws_02 = types.stoneSource,
			t_sky_terrrockre_rockseaws_03 = types.stoneSource,
			t_sky_terrrockre_rockseaws_04 = types.stoneSource,
			t_sky_terrrockre_rockseaws_05 = types.stoneSource,
			t_sky_terrrockre_rockseaws_06 = types.stoneSource,
			t_sky_terrrockre_rockseaws_07 = types.stoneSource,
			t_sky_terrrockre_rockseaws_08 = types.stoneSource,
			t_sky_terrrockre_rockseaws_09 = types.stoneSource,
			t_sky_terrrockre_rockseaws_10 = types.stoneSource,
			t_sky_terrrockre_rockseaws_11 = types.stoneSource,
			t_sky_terrrockres_rocklrg_01 = types.stoneSource,
			t_sky_terrrockres_rock_01 = types.stoneSource,
			t_sky_terrrockres_rocksml_01 = types.stoneSource,
			t_sky_terrrockres_rock_02 = types.stoneSource,
			t_sky_terrrockres_rock_03 = types.stoneSource,
			t_sky_terrrockres_rock_04 = types.stoneSource,
			t_sky_terrrockres_rock_05 = types.stoneSource,
			t_sky_terrrockres_rock_06 = types.stoneSource,
			t_sky_terrrockres_rock_07 = types.stoneSource,
			t_sky_terrrockres_rock_08 = types.stoneSource,
			t_sky_terrrockres_rockpky_01 = types.stoneSource,
			t_sky_terrrockres_rockflt_01 = types.stoneSource,
			t_sky_terrrockres_rockflt_02 = types.stoneSource,
			t_sky_terrrockres_rockpky_02 = types.stoneSource,
			t_sky_terrrockres_rock_09 = types.stoneSource,
			t_sky_terrrockres_rocksml_02 = types.stoneSource,
			t_sky_terrrockres_rocksml_03 = types.stoneSource,
			t_sky_terrrockres_rocksml_04 = types.stoneSource,
			t_sky_terrrockres_rockpky_03 = types.stoneSource,
			t_sky_terrrockres_rocksml_05 = types.stoneSource,
			t_sky_terrrockres_rocksml_06 = types.stoneSource,
			t_sky_terrrockres_rockpky_04 = types.stoneSource,
			t_sky_terrrockres_rock_10 = types.stoneSource,
			t_sky_terrrockres_rockpky_05 = types.stoneSource,
			t_sky_terrrockres_rockpky_06 = types.stoneSource,
			t_sky_terrrockres_rockflt_03 = types.stoneSource,
			t_sky_terrrockres_rockflt_04 = types.stoneSource,
			t_sky_terrrockres_rockpky_07 = types.stoneSource,
			t_sky_terrrockres_rockflt_05 = types.stoneSource,
			t_sky_terrrockres_rockflt_06 = types.stoneSource,
			t_sky_terrrockres_rockpky_08 = types.stoneSource,
			t_sky_terrrockres_rockflt_07 = types.stoneSource,
			t_sky_terrrockres_rockflt_08 = types.stoneSource,
			t_sky_terrrockres_rockflt_09 = types.stoneSource,
			t_sky_terrrockres_rockpky_09 = types.stoneSource,
			t_sky_terrrockres_rock_11 = types.stoneSource,
			t_sky_terrrockres_rock_12 = types.stoneSource,
			t_sky_terrrockres_rockflt_10 = types.stoneSource,
			t_sky_terrrockres_rockflt_11 = types.stoneSource,
			t_sky_terrrockres_rockflt_12 = types.stoneSource,
			t_sky_terrrockres_rockpky_10 = types.stoneSource,
			t_sky_terrrockres_rockflt_13 = types.stoneSource,
			t_sky_terrrockres_rocksml_07 = types.stoneSource,
			t_sky_terrrockres_rocksml_08 = types.stoneSource,
			t_sky_terrrockres_rocksml_09 = types.stoneSource,
			t_sky_terrrockres_rocksml_10 = types.stoneSource,
			t_sky_terrrockres_rock_13 = types.stoneSource,
			t_sky_terrrockres_rocksml_11 = types.stoneSource,
			t_sky_terrrockres_rocksml_12 = types.stoneSource,
			t_sky_terrrockres_rock_14 = types.stoneSource,
			t_sky_terrrockres_rocksml_13 = types.stoneSource,
			t_sky_terrrockres_rockflt_14 = types.stoneSource,
			t_sky_terrrockres_rockflt_15 = types.stoneSource,
			t_sky_terrrockres_rockflt_16 = types.stoneSource,
			t_sky_terrrockres_rockflt_17 = types.stoneSource,
			t_sky_terrrockres_rocklrg_02 = types.stoneSource,
			t_sky_terrrockres_rocksml_14 = types.stoneSource,
			t_sky_terrrockres_rock_15 = types.stoneSource,
			t_sky_terrrockres_rock_16 = types.stoneSource,
			t_sky_terrrockres_rocklrg_03 = types.stoneSource,
			t_sky_terrrockres_rocklrg_04 = types.stoneSource,
			t_sky_terrrockres_rockarc_01 = types.stoneSource,
			t_sky_terrrockres_rockarc_02 = types.stoneSource,
			t_sky_terrrockres_rockarc_03 = types.stoneSource,
			t_sky_terrrockres_rock_17 = types.stoneSource,
			t_sky_terrrockres_rock_18 = types.stoneSource,
			t_sky_terrrockres_rock_19 = types.stoneSource,
			t_sky_terrrockres_rock_20 = types.stoneSource,
			t_sky_terrrockres_rock_21 = types.stoneSource,
			t_sky_terrrockres_rock_22 = types.stoneSource,
			t_sky_terrrockres_rock_23 = types.stoneSource,
			t_sky_terrrockres_rocklrg_05 = types.stoneSource,
			t_sky_terrrockres_rock_24 = types.stoneSource,
			t_sky_terrrockres_rock_25 = types.stoneSource,
			t_sky_terrrockres_rockgrp_01 = types.stoneSource,
			t_sky_terrrockres_rockgrp_02 = types.stoneSource,
			t_sky_terrrockres_rockgrp_03 = types.stoneSource,
			t_sky_terrrockres_rockgrp_04 = types.stoneSource,
			t_sky_terrrockre_plane_01 = types.stoneSource,
			t_sky_cavere_i_rock_01 = types.stoneSource,
			t_sky_cavere_i_rock_02 = types.stoneSource,
			t_sky_cavere_i_rock_03 = types.stoneSource,
			t_sky_cavere_i_rock_04 = types.stoneSource,
			t_sky_cavere_i_rock_05 = types.stoneSource,
			t_sky_cavere_i_rock_06 = types.stoneSource,
			t_sky_cavere_i_rock_07 = types.stoneSource,
			t_sky_cavere_i_stalagmite_01 = types.stoneSource,
			t_sky_cavere_i_stalagmite_02 = types.stoneSource,
			t_sky_cavere_i_stalagmite_03 = types.stoneSource,
			t_sky_cavere_i_stalagmite_04 = types.stoneSource,
			t_sky_cavere_i_stalagmite_05 = types.stoneSource,
			t_sky_cavere_i_stalagmite_06 = types.stoneSource,
			t_sky_cavere_i_stalagmite_07 = types.stoneSource,
			t_sky_cavere_i_stalagmite_08 = types.stoneSource,
			t_sky_cavere_i_stalagmite_09 = types.stoneSource,
			t_sky_cavere_i_stalagmite_10 = types.stoneSource,
			t_sky_cavere_i_stalagmite_11 = types.stoneSource,
			t_sky_cavere_i_rock_08 = types.stoneSource,
			t_sky_cavere_i_rock_09 = types.stoneSource,
			t_sky_cavere_i_rock_10 = types.stoneSource,
			t_sky_cavere_i_rock_11 = types.stoneSource,
			t_sky_cavere_i_rock_12 = types.stoneSource,
			t_sky_cavere_i_rock_13 = types.stoneSource,
			t_sky_cavere_i_rock_14 = types.stoneSource,
			t_sky_cavere_i_rock_15 = types.stoneSource,
			t_sky_cavere_i_rock_16 = types.stoneSource,
			t_sky_cavere_i_rock_17 = types.stoneSource,
			t_sky_cavere_i_rock_18 = types.stoneSource,

			t_mw_floraow_rockburst_01 = types.stoneSource,
			t_mw_floraow_rockburst_02 = types.stoneSource,
			t_mw_floraow_rockburst_03 = types.stoneSource,
			t_mw_floraow_rockburst_04 = types.stoneSource,
			t_mw_floraow_rockburst_05 = types.stoneSource,
			t_mw_cavemold_rock_01 = types.stoneSource,
			t_mw_cavemold_rock_02 = types.stoneSource,
			t_mw_cavemold_rock_03 = types.stoneSource,
			t_mw_cavevm_rockform_00 = types.stoneSource,
			t_mw_cavevm_rockform_01 = types.stoneSource,
			t_mw_cavevm_rockform_02 = types.stoneSource,
			t_mw_cavevm_rockform_03 = types.stoneSource,
			t_mw_cavevm_rockstal_00 = types.stoneSource,
			t_mw_cavevm_rockstal_01 = types.stoneSource,
			t_mw_cavevm_rockstal_02 = types.stoneSource,
			t_mw_cavevm_rockstal_03 = types.stoneSource,
			t_mw_cavevm_rockstal_04 = types.stoneSource,
			t_mw_cavevm_rockstal_05 = types.stoneSource,
			t_mw_terrrockai_cliff_01 = types.stoneSource,
			t_mw_terrrockai_cliff_02 = types.stoneSource,
			t_mw_terrrockai_cliff_03 = types.stoneSource,
			t_mw_terrrockai_cliff_04 = types.stoneSource,
			t_mw_terrrockai_cliff_05 = types.stoneSource,
			t_mw_terrrockai_cliff_06 = types.stoneSource,
			t_mw_terrrockbc_cliffs_01 = types.stoneSource,
			t_mw_terrrockbc_cliffs_02 = types.stoneSource,
			t_mw_terrrockbc_cliffs_03 = types.stoneSource,
			t_mw_terrrockbc_cliffs_04 = types.stoneSource,
			t_mw_terrrockvm_stalags_01 = types.stoneSource,
			t_mw_terrrockvm_stalags_02 = types.stoneSource,
			t_mw_terrrockvm_stalags_03 = types.stoneSource,
			t_mw_terrrockvm_stalags_04 = types.stoneSource,
			t_mw_terrrockvm_stalags_05 = types.stoneSource,
			t_mw_terrrockvm_stalags_06 = types.stoneSource,
			t_mw_terrrockvm_cliffhalf_01b = types.stoneSource,
			t_mw_terrrockvm_cliff_01b = types.stoneSource,
			t_mw_terrrockvm_cliffhalf_02b = types.stoneSource,
			t_mw_terrrockvm_cliff_02b = types.stoneSource,
			t_mw_terrrockvm_cliffhalf_03b = types.stoneSource,
			t_mw_terrrockvm_cliff_03b = types.stoneSource,
			t_mw_terrrockvm_cliffhalf_04b = types.stoneSource,
			t_mw_terrrockvm_cliff_04b = types.stoneSource,
			t_mw_terrrockvm_cliffhalf_05b = types.stoneSource,
			t_mw_terrrockvm_cliff_05b = types.stoneSource,
			t_mw_terrrockvm_cliffhalf_06b = types.stoneSource,
			t_mw_terrrockvm_cliff_06b = types.stoneSource,
			t_mw_terrrockrm_cliffs_01 = types.stoneSource,
			t_mw_terrrockrm_cliffs_02 = types.stoneSource,
			t_mw_terrrockrm_cliffs_03 = types.stoneSource,
			t_mw_terrrockrm_cliffs_04 = types.stoneSource,
			t_mw_terrrockrma_cliffs_01 = types.stoneSource,
			t_mw_terrrockrma_cliffs_02 = types.stoneSource,
			t_mw_terrrockrma_cliffs_03 = types.stoneSource,
			t_mw_terrrockrma_cliffs_04 = types.stoneSource,
			t_mw_terrrockrms_cliffs_01 = types.stoneSource,
			t_mw_terrrockrms_cliffs_02 = types.stoneSource,
			t_mw_terrrockrms_cliffs_03 = types.stoneSource,
			t_mw_terrrockrms_cliffs_04 = types.stoneSource,
			t_mw_terrrocktv_cliffs_01 = types.stoneSource,
			t_mw_terrrocktv_cliffs_01b = types.stoneSource,
			t_mw_terrrocktv_cliffs_01c = types.stoneSource,
			t_mw_terrrocktv_cliffs_02 = types.stoneSource,
			t_mw_terrrocktv_cliffs_02b = types.stoneSource,
			t_mw_terrrocktv_cliffs_02c = types.stoneSource,
			t_mw_terrrocktv_cliffs_03 = types.stoneSource,
			t_mw_terrrocktv_cliffs_03b = types.stoneSource,
			t_mw_terrrocktv_cliffs_03c = types.stoneSource,
			t_mw_terrrocktv_cliffs_04 = types.stoneSource,
			t_mw_terrrocktv_cliffs_04b = types.stoneSource,
			t_mw_terrrocktv_cliffs_04c = types.stoneSource,
			t_mw_terrrockgl_mtpeak_01 = types.stoneSource,
			t_mw_terrrockgl_mtpeak_02 = types.stoneSource,
			t_mw_terrrockgl_mtpeak_03 = types.stoneSource,
			t_mw_terrrockgl_mtridgetrv_01 = types.stoneSource,
			t_mw_terrrockgl_mtridgetrv_02 = types.stoneSource,
			t_mw_terrrockgl_mtridgetrv_03 = types.stoneSource,
			t_mw_terrrockgl_rock_01 = types.stoneSource,
			t_mw_terrrockgl_rock_02 = types.stoneSource,
			t_mw_terrrockgl_rock_03 = types.stoneSource,
			t_mw_terrrockgl_rock_04 = types.stoneSource,
			t_mw_terrrockgl_rock_05 = types.stoneSource,
			t_mw_terrrockgl_rock_06 = types.stoneSource,
			t_mw_terrrockgl_rock_07 = types.stoneSource,
			t_mw_terrrockgl_cliff_01 = types.stoneSource,
			t_mw_terrrockgl_cliff_02 = types.stoneSource,
			t_mw_terrrockgl_cliff_03 = types.stoneSource,
			t_mw_terrrockgl_cliff_04 = types.stoneSource,
			t_mw_terrrockgl_cliff_05 = types.stoneSource,
			t_mw_terrrockgl_cliff_06 = types.stoneSource,
			t_mw_terrrockma_cliff_01 = types.stoneSource,
			t_mw_terrrockma_cliff_02 = types.stoneSource,
			t_mw_terrrockma_cliff_03 = types.stoneSource,
			t_mw_terrrockma_cliff_04 = types.stoneSource,
			t_mw_terrrockma_cliff_05 = types.stoneSource,
			t_mw_terrrockma_cliff_06 = types.stoneSource,
			t_mw_terrrockma_mtpeak_01 = types.stoneSource,
			t_mw_terrrockma_mtpeak_02 = types.stoneSource,
			t_mw_terrrockma_mtpeak_03 = types.stoneSource,
			t_mw_terrrockma_mtridge_01 = types.stoneSource,
			t_mw_terrrockma_mtridge_02 = types.stoneSource,
			t_mw_terrrockma_mtridge_03 = types.stoneSource,
			t_mw_terrrockma_stalags1_01 = types.stoneSource,
			t_mw_terrrockma_stalags1_02 = types.stoneSource,
			t_mw_terrrockma_stalags1_03 = types.stoneSource,
			t_mw_terrrockma_stalags1_04 = types.stoneSource,
			t_mw_terrrockma_stalags1_05 = types.stoneSource,
			t_mw_terrrockma_stalags1_06 = types.stoneSource,
			t_mw_terrrockma_stalags2_01 = types.stoneSource,
			t_mw_terrrockma_stalags2_02 = types.stoneSource,
			t_mw_terrrockma_stalags2_03 = types.stoneSource,
			t_mw_terrrockma_stalags2_04 = types.stoneSource,
			t_mw_terrrockma_stalags2_05 = types.stoneSource,
			t_mw_terrrockma_stalags2_06 = types.stoneSource,
			t_mw_terrrockow_rock1_01 = types.stoneSource,
			t_mw_terrrockow_rock1_02 = types.stoneSource,
			t_mw_terrrockow_rock1_03 = types.stoneSource,
			t_mw_terrrockow_rock1_05 = types.stoneSource,
			t_mw_terrrockow_rock1_06 = types.stoneSource,
			t_mw_terrrockow_rock1_07 = types.stoneSource,
			t_mw_terrrockow_rock1_08 = types.stoneSource,
			t_mw_terrrockow_rock1_09 = types.stoneSource,
			t_mw_terrrockow_rock1_10 = types.stoneSource,
			t_mw_terrrockow_rock1_11 = types.stoneSource,
			t_mw_terrrockow_rock1_12 = types.stoneSource,
			t_mw_terrrockow_rock1_13 = types.stoneSource,
			t_mw_terrrockow_rock1_14 = types.stoneSource,
			t_mw_terrrockow_rock1_15 = types.stoneSource,
			t_mw_terrrockow_rock2_01 = types.stoneSource,
			t_mw_terrrockow_rock2_02 = types.stoneSource,
			t_mw_terrrockow_rock2_03 = types.stoneSource,
			t_mw_terrrockow_rock1_04 = types.stoneSource,
			t_mw_terrrockow_rock2_04 = types.stoneSource,
			t_mw_terrrockow_rock2_05 = types.stoneSource,
			t_mw_terrrockow_rock2_06 = types.stoneSource,
			t_mw_terrrockow_rock2_07 = types.stoneSource,
			t_mw_terrrockow_rock2_08 = types.stoneSource,
			t_mw_terrrockow_rock2_09 = types.stoneSource,
			t_mw_terrrockow_rock2_10 = types.stoneSource,
			t_mw_terrrockow_rock2_11 = types.stoneSource,
			t_mw_terrrockow_rock2_12 = types.stoneSource,
			t_mw_terrrockow_rock2_13 = types.stoneSource,
			t_mw_terrrockow_rock2_14 = types.stoneSource,
			t_mw_terrrockow_rock2_15 = types.stoneSource,
			t_mw_terrrockrm_cliffash_01 = types.stoneSource,
			t_mw_terrrockrm_cliffash_02 = types.stoneSource,
			t_mw_terrrockrm_mtpeak_01 = types.stoneSource,
			t_mw_terrrockrm_mtpeak_02 = types.stoneSource,
			t_mw_terrrockrm_mtpeak_03 = types.stoneSource,
			t_mw_terrrockrm_mtridge_01 = types.stoneSource,
			t_mw_terrrockrm_mtridge_02 = types.stoneSource,
			t_mw_terrrockrm_mtridge_03 = types.stoneSource,
			t_mw_terrrockrm_cliffhalf_01 = types.stoneSource,
			t_mw_terrrockrm_cliffhalf_02 = types.stoneSource,
			t_mw_terrrockrm_cliffhalf_03 = types.stoneSource,
			t_mw_terrrockrm_cliffhalf_04 = types.stoneSource,
			t_mw_terrrockrm_cliffhalf_05 = types.stoneSource,
			t_mw_terrrockrm_cliffhalf_06 = types.stoneSource,
			t_mw_terrrockrm_cliff_01 = types.stoneSource,
			t_mw_terrrockrm_cliff_02 = types.stoneSource,
			t_mw_terrrockrm_cliff_03 = types.stoneSource,
			t_mw_terrrockrm_cliff_04 = types.stoneSource,
			t_mw_terrrockrm_cliff_05 = types.stoneSource,
			t_mw_terrrockrm_cliff_06 = types.stoneSource,
			t_mw_terrrockrm_cliff_07 = types.stoneSource,
			t_mw_terrrockrm_cliff_08 = types.stoneSource,
			t_mw_terrrockrm_cliff_09 = types.stoneSource,
			t_mw_terrrockrm_mtpeak_04 = types.stoneSource,
			t_mw_terrrockrm_mtpeak_05 = types.stoneSource,
			t_mw_terrrockgl_rock_08 = types.stoneSource,
			t_mw_terrrockgl_rock_09 = types.stoneSource,
			t_mw_terrrockgl_rock_10 = types.stoneSource,
			t_mw_terrrockgl_rock_11 = types.stoneSource,
			t_mw_terrrockgl_rock_12 = types.stoneSource,
			t_mw_terrrockgl_rock_13 = types.stoneSource,
			t_mw_terrrockgl_rock_14 = types.stoneSource,
			t_mw_terrrockgl_rock_15 = types.stoneSource,
			t_mw_terrrockgl_rock_16 = types.stoneSource,
			t_mw_terrrockgl_rock_17 = types.stoneSource,
			t_mw_terrrockgl_rock_18 = types.stoneSource,
			t_mw_terrrockrr_rock_01 = types.stoneSource,
			t_mw_terrrockrr_rock_02 = types.stoneSource,
			t_mw_terrrockrr_rock_03 = types.stoneSource,
			t_mw_terrrockrr_rock_04 = types.stoneSource,
			t_mw_terrrockrr_rock_05 = types.stoneSource,
			t_mw_terrrockrr_rock_06 = types.stoneSource,
			t_mw_terrrockrr_rock_07 = types.stoneSource,
			t_mw_terrrockrr_rock_08 = types.stoneSource,
			t_mw_terrrockrr_rock_09 = types.stoneSource,
			t_mw_terrrockrr_rock_10 = types.stoneSource,
			t_mw_terrrockrr_rock_11 = types.stoneSource,
			t_mw_terrrockrr_rock_12 = types.stoneSource,
			t_mw_terrrockrr_rock_13 = types.stoneSource,
			t_mw_terrrockrr_rock_14 = types.stoneSource,
			t_mw_terrrockrr_rock_15 = types.stoneSource,
			t_mw_terrrockrr_rock_16 = types.stoneSource,
			t_mw_terrrockrr_rock_17 = types.stoneSource,
			t_mw_terrrockrr_rock_18 = types.stoneSource,
			t_mw_terrrockrr_rock_19 = types.stoneSource,
			t_mw_terrrockrr_rock_20 = types.stoneSource,
			t_mw_terrrockrr_rock_21 = types.stoneSource,
			t_mw_terrrockrr_rock_22 = types.stoneSource,
			t_mw_terrrockrr_rock_23 = types.stoneSource,
			t_mw_terrrockrr_rock_24 = types.stoneSource,
			t_mw_terrrockrr_rock_25 = types.stoneSource,
			t_mw_terrrockrr_rock_26 = types.stoneSource,
			t_mw_terrrockrr_rock_27 = types.stoneSource,
			t_mw_terrrockrr_rock_28 = types.stoneSource,
			t_mw_terrrockrr_rock_29 = types.stoneSource,
			t_mw_terrrockrr_rock_30 = types.stoneSource,
			t_mw_terrrocktv_rock_08 = types.stoneSource,
			t_mw_terrrocktv_rock_09 = types.stoneSource,
			t_mw_terrrocktv_rock_10 = types.stoneSource,
			t_mw_terrrocktv_rock_11 = types.stoneSource,
			t_mw_terrrocktv_rock_12 = types.stoneSource,
			t_mw_terrrocktv_rock_13 = types.stoneSource,
			t_mw_terrrocktv_rock_14 = types.stoneSource,
			t_mw_terrrocktv_rock_15 = types.stoneSource,
			t_mw_terrrocktv_rock_16 = types.stoneSource,
			t_mw_terrrocktv_rock_17 = types.stoneSource,
			t_mw_terrrocktv_rock_18 = types.stoneSource,
			t_mw_terrrockgl_cliffrr_01 = types.stoneSource,
			t_mw_terrrockgl_cliffrr_02 = types.stoneSource,
			t_mw_terrrockgl_cliffrr_03 = types.stoneSource,
			t_mw_terrrockgl_cliffrr_04 = types.stoneSource,
			t_mw_terrrockgl_cliffrr_05 = types.stoneSource,
			t_mw_terrrockgl_cliffrr_06 = types.stoneSource,
			t_mw_terrrockgl_cliffrr_07 = types.stoneSource,
			t_mw_terrrockgl_cliffrrsb_01 = types.stoneSource,
			t_mw_terrrockgl_cliffrrsb_02 = types.stoneSource,
			t_mw_terrrockgl_cliffrrsb_03 = types.stoneSource,
			t_mw_terrrockgl_cliffrrsb_04 = types.stoneSource,
			t_mw_terrrockrr_cliffm_01 = types.stoneSource,
			t_mw_terrrockrr_cliffm_02 = types.stoneSource,
			t_mw_terrrockrr_cliffm_03 = types.stoneSource,
			t_mw_terrrockrr_cliffm_04 = types.stoneSource,
			t_mw_terrrockrr_cliffm_05 = types.stoneSource,
			t_mw_terrrockrr_cliffm_06 = types.stoneSource,
			t_mw_terrrockrr_cliffm_07 = types.stoneSource,
			t_mw_terrrockrr_cliffs_01a = types.stoneSource,
			t_mw_terrrockrr_cliffs_01b = types.stoneSource,
			t_mw_terrrockrr_cliffs_02a = types.stoneSource,
			t_mw_terrrockrr_cliffs_02b = types.stoneSource,
			t_mw_terrrockrr_cliffs_03a = types.stoneSource,
			t_mw_terrrockrr_cliffs_03b = types.stoneSource,
			t_mw_terrrockrr_cliffs_04a = types.stoneSource,
			t_mw_terrrockrr_cliffs_04b = types.stoneSource,
			t_mw_terrrockrr_mtpeak_01 = types.stoneSource,
			t_mw_terrrockrr_mtpeak_02 = types.stoneSource,
			t_mw_terrrockrr_mtpeak_03 = types.stoneSource,
			t_mw_terrrockrr_mtridge_01 = types.stoneSource,
			t_mw_terrrockrr_mtridge_02 = types.stoneSource,
			t_mw_terrrockrr_mtridge_03 = types.stoneSource,
			t_mw_terrrockrr_cliffhalf_01 = types.stoneSource,
			t_mw_terrrockrr_cliff_01 = types.stoneSource,
			t_mw_terrrockrr_cliffhalf_02 = types.stoneSource,
			t_mw_terrrockrr_cliff_02 = types.stoneSource,
			t_mw_terrrockrr_cliffhalf_03 = types.stoneSource,
			t_mw_terrrockrr_cliff_03 = types.stoneSource,
			t_mw_terrrockrr_cliffhalf_04 = types.stoneSource,
			t_mw_terrrockrr_cliff_04 = types.stoneSource,
			t_mw_terrrockrr_cliffhalf_05 = types.stoneSource,
			t_mw_terrrockrr_cliff_05 = types.stoneSource,
			t_mw_terrrockrr_cliffhalf_06 = types.stoneSource,
			t_mw_terrrockrr_cliff_06 = types.stoneSource,
			t_mw_terrrocksh_art_clf01_01 = types.stoneSource,
			t_mw_terrrocksh_art_clf01_02 = types.stoneSource,
			t_mw_terrrocksh_art_clf01_03 = types.stoneSource,
			t_mw_terrrocksh_art_clf02_01 = types.stoneSource,
			t_mw_terrrocksh_art_clf02_02 = types.stoneSource,
			t_mw_terrrocksh_art_clf02_03 = types.stoneSource,
			t_mw_terrrocksh_art_clf03_01 = types.stoneSource,
			t_mw_terrrocksh_art_clf03_02 = types.stoneSource,
			t_mw_terrrocksh_art_clf03_03 = types.stoneSource,
			t_mw_terrrocksh_art_rock01_01 = types.stoneSource,
			t_mw_terrrocksh_art_rock01_02 = types.stoneSource,
			t_mw_terrrocksh_art_rock01_03 = types.stoneSource,
			t_mw_terrrocksh_art_rock03_01 = types.stoneSource,
			t_mw_terrrocksh_cliff01_01a = types.stoneSource,
			t_mw_terrrocksh_cliff01_01b = types.stoneSource,
			t_mw_terrrocksh_cliff01_02a = types.stoneSource,
			t_mw_terrrocksh_cliff01_02b = types.stoneSource,
			t_mw_terrrocksh_cliff01_03a = types.stoneSource,
			t_mw_terrrocksh_cliff01_03b = types.stoneSource,
			t_mw_terrrocksh_cliff01_04a = types.stoneSource,
			t_mw_terrrocksh_cliff01_04b = types.stoneSource,
			t_mw_terrrocksh_cliff01_05a = types.stoneSource,
			t_mw_terrrocksh_cliff01_05b = types.stoneSource,
			t_mw_terrrocksh_cliff01_06a = types.stoneSource,
			t_mw_terrrocksh_cliff01_06b = types.stoneSource,
			t_mw_terrrocksh_cliff01_07a = types.stoneSource,
			t_mw_terrrocksh_cliff01_07b = types.stoneSource,
			t_mw_terrrocksh_cliff01_08a = types.stoneSource,
			t_mw_terrrocksh_cliff01_08b = types.stoneSource,
			t_mw_terrrocksh_cliff01_09a = types.stoneSource,
			t_mw_terrrocksh_cliff01_09b = types.stoneSource,
			t_mw_terrrocksh_cliff02_01a = types.stoneSource,
			t_mw_terrrocksh_cliff02_01b = types.stoneSource,
			t_mw_terrrocksh_cliff02_02a = types.stoneSource,
			t_mw_terrrocksh_cliff02_02b = types.stoneSource,
			t_mw_terrrocksh_cliff02_03a = types.stoneSource,
			t_mw_terrrocksh_cliff02_03b = types.stoneSource,
			t_mw_terrrocksh_cliff02_04a = types.stoneSource,
			t_mw_terrrocksh_cliff02_04b = types.stoneSource,
			t_mw_terrrocksh_cliff02_05a = types.stoneSource,
			t_mw_terrrocksh_cliff02_05b = types.stoneSource,
			t_mw_terrrocksh_cliff02_06a = types.stoneSource,
			t_mw_terrrocksh_cliff02_06b = types.stoneSource,
			t_mw_terrrocksh_cliff02_07a = types.stoneSource,
			t_mw_terrrocksh_cliff02_07b = types.stoneSource,
			t_mw_terrrocksh_cliff02_08a = types.stoneSource,
			t_mw_terrrocksh_cliff02_08b = types.stoneSource,
			t_mw_terrrocksh_cliff02_09a = types.stoneSource,
			t_mw_terrrocksh_cliff02_09b = types.stoneSource,
			t_mw_terrrocksh_cliff03_01 = types.stoneSource,
			t_mw_terrrocksh_cliff03_01b = types.stoneSource,
			t_mw_terrrocksh_cliff03_02 = types.stoneSource,
			t_mw_terrrocksh_cliff03_02b = types.stoneSource,
			t_mw_terrrocksh_cliff03_03 = types.stoneSource,
			t_mw_terrrocksh_cliff03_03b = types.stoneSource,
			t_mw_terrrocksh_cliff03_04 = types.stoneSource,
			t_mw_terrrocksh_cliff03_04b = types.stoneSource,
			t_mw_terrrocksh_cliff03_05 = types.stoneSource,
			t_mw_terrrocksh_cliff03_05b = types.stoneSource,
			t_mw_terrrocksh_cliff03_06 = types.stoneSource,
			t_mw_terrrocksh_cliff03_06b = types.stoneSource,
			t_mw_terrrocksh_cliff03_07 = types.stoneSource,
			t_mw_terrrocksh_cliff03_07b = types.stoneSource,
			t_mw_terrrocksh_cliff03_08 = types.stoneSource,
			t_mw_terrrocksh_cliff03_08b = types.stoneSource,
			t_mw_terrrocksh_cliff03_09a = types.stoneSource,
			t_mw_terrrocksh_cliff03_09b = types.stoneSource,
			t_mw_terrrocksh_cliffs01_01 = types.stoneSource,
			t_mw_terrrocksh_cliffs01_02 = types.stoneSource,
			t_mw_terrrocksh_cliffs01_03 = types.stoneSource,
			t_mw_terrrocksh_cliffs01_04 = types.stoneSource,
			t_mw_terrrocksh_cliffs01_05 = types.stoneSource,
			t_mw_terrrocksh_cliffs01_06 = types.stoneSource,
			t_mw_terrrocksh_cliffs02_01 = types.stoneSource,
			t_mw_terrrocksh_cliffs02_02 = types.stoneSource,
			t_mw_terrrocksh_cliffs02_03 = types.stoneSource,
			t_mw_terrrocksh_cliffs02_04 = types.stoneSource,
			t_mw_terrrocksh_cliffs02_05 = types.stoneSource,
			t_mw_terrrocksh_cliffs02_06 = types.stoneSource,
			t_mw_terrrocksh_cliffs03_01 = types.stoneSource,
			t_mw_terrrocksh_cliffs03_02 = types.stoneSource,
			t_mw_terrrocksh_cliffs03_03 = types.stoneSource,
			t_mw_terrrocksh_cliffs03_04 = types.stoneSource,
			t_mw_terrrocksh_cliffs03_05 = types.stoneSource,
			t_mw_terrrocksh_cliffs03_06 = types.stoneSource,
			t_mw_terrrocksh_rock1_01 = types.stoneSource,
			t_mw_terrrocksh_rock1_02 = types.stoneSource,
			t_mw_terrrocksh_rock1_03 = types.stoneSource,
			t_mw_terrrocksh_rock1_04 = types.stoneSource,
			t_mw_terrrocksh_rock1_05 = types.stoneSource,
			t_mw_terrrocksh_rock1_06 = types.stoneSource,
			t_mw_terrrocksh_rock1_07 = types.stoneSource,
			t_mw_terrrocksh_rock1_08 = types.stoneSource,
			t_mw_terrrocksh_rock1_09 = types.stoneSource,
			t_mw_terrrocksh_rock1_10 = types.stoneSource,
			t_mw_terrrocksh_rock1_11 = types.stoneSource,
			t_mw_terrrocksh_rock1_12 = types.stoneSource,
			t_mw_terrrocksh_rock1_13 = types.stoneSource,
			t_mw_terrrocksh_rock1_14 = types.stoneSource,
			t_mw_terrrocksh_rock1_15 = types.stoneSource,
			t_mw_terrrocksh_rock2_01 = types.stoneSource,
			t_mw_terrrocksh_rock2_02 = types.stoneSource,
			t_mw_terrrocksh_rock2_03 = types.stoneSource,
			t_mw_terrrocksh_rock2_04 = types.stoneSource,
			t_mw_terrrocksh_rock2_05 = types.stoneSource,
			t_mw_terrrocksh_rock2_06 = types.stoneSource,
			t_mw_terrrocksh_rock2_07 = types.stoneSource,
			t_mw_terrrocksh_rock2_08 = types.stoneSource,
			t_mw_terrrocksh_rock2_09 = types.stoneSource,
			t_mw_terrrocksh_rock2_10 = types.stoneSource,
			t_mw_terrrocksh_rock2_11 = types.stoneSource,
			t_mw_terrrocksh_rock2_12 = types.stoneSource,
			t_mw_terrrocksh_rock2_13 = types.stoneSource,
			t_mw_terrrocksh_rock2_14 = types.stoneSource,
			t_mw_terrrocksh_rock2_15 = types.stoneSource,
			t_mw_terrrocksh_rock3_01 = types.stoneSource,
			t_mw_terrrocksh_rock3_02 = types.stoneSource,
			t_mw_terrrocksh_rock3_03 = types.stoneSource,
			t_mw_terrrocksh_rock3_04 = types.stoneSource,
			t_mw_terrrocksh_rock3_05 = types.stoneSource,
			t_mw_terrrocksh_rock3_06 = types.stoneSource,
			t_mw_terrrocksh_rock3_07 = types.stoneSource,
			t_mw_terrrocksh_rock3_08 = types.stoneSource,
			t_mw_terrrocksh_rock3_09 = types.stoneSource,
			t_mw_terrrocksh_rock3_10 = types.stoneSource,
			t_mw_terrrockai_clifftrv_01 = types.stoneSource,
			t_mw_terrrockai_clifftrv_02 = types.stoneSource,
			t_mw_terrrockai_clifftrv_03 = types.stoneSource,
			t_mw_terrrockai_clifftrv_04 = types.stoneSource,
			t_mw_terrrockai_clifftrv_05 = types.stoneSource,
			t_mw_terrrockai_clifftrv_06 = types.stoneSource,
			t_mw_terrrockai_mtpeaktrv_01 = types.stoneSource,
			t_mw_terrrockai_mtpeaktrv_02 = types.stoneSource,
			t_mw_terrrockai_mtpeaktrv_03 = types.stoneSource,
			t_mw_terrrockai_mtridgetrv_01 = types.stoneSource,
			t_mw_terrrockai_mtridgetrv_02 = types.stoneSource,
			t_mw_terrrockai_mtridgetrv_03 = types.stoneSource,
			t_mw_terrrocktv_mtpeak_01 = types.stoneSource,
			t_mw_terrrocktv_mtpeak_02 = types.stoneSource,
			t_mw_terrrocktv_mtpeak_03 = types.stoneSource,
			t_mw_terrrocktv_mtridge_01 = types.stoneSource,
			t_mw_terrrocktv_mtridge_02 = types.stoneSource,
			t_mw_terrrocktv_mtridge_03 = types.stoneSource,
			t_mw_terrrocktv_rock_01 = types.stoneSource,
			t_mw_terrrocktv_rock_02 = types.stoneSource,
			t_mw_terrrocktv_rock_03 = types.stoneSource,
			t_mw_terrrocktv_rock_04 = types.stoneSource,
			t_mw_terrrocktv_rock_05 = types.stoneSource,
			t_mw_terrrocktv_rock_06 = types.stoneSource,
			t_mw_terrrocktv_rock_07 = types.stoneSource,
			t_mw_terrrockvm_cliffgrass_01 = types.stoneSource,
			t_mw_terrrockvm_cliffgrass_02 = types.stoneSource,
			t_mw_terrrockvm_cliffgrass_03 = types.stoneSource,
			t_mw_terrrockvm_cliffgrass_04 = types.stoneSource,
			t_mw_terrrockvm_cliffgrass_05 = types.stoneSource,
			t_mw_terrrockvm_cliffgrass_06 = types.stoneSource,
			t_mw_terrrockvm_cliffm_01 = types.stoneSource,
			t_mw_terrrockvm_cliffm_02 = types.stoneSource,
			t_mw_terrrockvm_cliffm_03 = types.stoneSource,
			t_mw_terrrockvm_cliffm_04 = types.stoneSource,
			t_mw_terrrockvm_cliffm_06 = types.stoneSource,
			t_mw_terrrockvm_cliffgrasssm_01 = types.stoneSource,
			t_mw_terrrockvm_cliffgrasssm_02 = types.stoneSource,
			t_mw_terrrockvm_cliffgrasssm_03 = types.stoneSource,
			t_mw_terrrockvm_cliffgrasssm_04 = types.stoneSource,
			t_mw_terrrockvm_cliffgrsnwsm_01 = types.stoneSource,
			t_mw_terrrockvm_cliffgrsnwsm_02 = types.stoneSource,
			t_mw_terrrockvm_cliffgrsnwsm_03 = types.stoneSource,
			t_mw_terrrockvm_cliffgrsnwsm_04 = types.stoneSource,
			t_mw_terrrockvm_cliffgrsnw_01 = types.stoneSource,
			t_mw_terrrockvm_cliffgrsnw_02 = types.stoneSource,
			t_mw_terrrockvm_cliffgrsnw_03 = types.stoneSource,
			t_mw_terrrockvm_cliffgrsnw_04 = types.stoneSource,
			t_mw_terrrockvm_cliffgrsnw_05 = types.stoneSource,
			t_mw_terrrockvm_cliffgrsnw_06 = types.stoneSource,
			t_mw_terrrockvm_cliffsnow_01 = types.stoneSource,
			t_mw_terrrockvm_cliffsnow_02 = types.stoneSource,
			t_mw_terrrockvm_cliffsnow_03 = types.stoneSource,
			t_mw_terrrockvm_cliffsnow_04 = types.stoneSource,
			t_mw_terrrockvm_cliffsnow_05 = types.stoneSource,
			t_mw_terrrockvm_cliffsnow_06 = types.stoneSource,
			t_mw_terrrockvm_cliffsnowsm_01 = types.stoneSource,
			t_mw_terrrockvm_cliffsnowsm_02 = types.stoneSource,
			t_mw_terrrockvm_cliffsnowsm_03 = types.stoneSource,
			t_mw_terrrockvm_cliffsnowsm_04 = types.stoneSource,
			t_mw_terrrockvm_mtpeak_01 = types.stoneSource,
			t_mw_terrrockvm_mtpeak_02 = types.stoneSource,
			t_mw_terrrockvm_mtpeak_03 = types.stoneSource,
			t_mw_terrrockvm_mtridge_01 = types.stoneSource,
			t_mw_terrrockvm_mtridge_02 = types.stoneSource,
			t_mw_terrrockvm_mtridge_03 = types.stoneSource,
			t_mw_terrrockvm_rock_18 = types.stoneSource,
			t_mw_terrrockvm_rock_19 = types.stoneSource,
			t_mw_terrrockvm_rock_20 = types.stoneSource,
			t_mw_terrrockvm_rock_21 = types.stoneSource,
			t_mw_terrrockvm_rock_22 = types.stoneSource,
			t_mw_terrrockvm_rock_23 = types.stoneSource,
			t_mw_terrrockvm_rock_24 = types.stoneSource,
			t_mw_terrrockvm_rock_25 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_05 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_06 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_07 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_08 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_09 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_10 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_11 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_12 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_13 = types.stoneSource,
			t_mw_terrrockwg_cliff_01 = types.stoneSource,
			t_mw_terrrockwg_cliff_02 = types.stoneSource,
			t_mw_terrrockwg_cliff_03 = types.stoneSource,
			t_mw_terrrockwg_cliff_04 = types.stoneSource,
			t_mw_terrrockwg_cliff_05 = types.stoneSource,
			t_mw_terrrockwg_cliff_06 = types.stoneSource,
			t_mw_terrrockwg_cliffm_01 = types.stoneSource,
			t_mw_terrrockwg_cliffm_02 = types.stoneSource,
			t_mw_terrrockwg_cliffm_03 = types.stoneSource,
			t_mw_terrrockwg_cliffm_04 = types.stoneSource,
			t_mw_terrrockwg_cliffm_06 = types.stoneSource,
			t_mw_terrrockwg_mtpeak_01 = types.stoneSource,
			t_mw_terrrockwg_mtpeak_02 = types.stoneSource,
			t_mw_terrrockwg_mtpeak_03 = types.stoneSource,
			t_mw_terrrockwg_mtridge_01 = types.stoneSource,
			t_mw_terrrockwg_mtridge_02 = types.stoneSource,
			t_mw_terrrockwg_mtridge_03 = types.stoneSource,
			t_mw_terrrockai_rock_01 = types.stoneSource,
			t_mw_terrrockai_rock_02 = types.stoneSource,
			t_mw_terrrockai_rock_03 = types.stoneSource,
			t_mw_terrrockai_rock_04 = types.stoneSource,
			t_mw_terrrockai_rock_05 = types.stoneSource,
			t_mw_terrrockai_rock_06 = types.stoneSource,
			t_mw_terrrockai_rock_07 = types.stoneSource,
			t_mw_terrrockai_rock_08 = types.stoneSource,
			t_mw_terrrockai_rock_09 = types.stoneSource,
			t_mw_terrrockai_rock_10 = types.stoneSource,
			t_mw_terrrockai_rock_11 = types.stoneSource,
			t_mw_terrrockai_rock_12 = types.stoneSource,
			t_mw_terrrockai_rock_13 = types.stoneSource,
			t_mw_terrrockai_rock_14 = types.stoneSource,
			t_mw_terrrockai_rock_15 = types.stoneSource,
			t_mw_terrrockai_rock_16 = types.stoneSource,
			t_mw_terrrockai_rock_17 = types.stoneSource,
			t_mw_terrrockai_rock_18 = types.stoneSource,
			t_mw_terrrockbc_rockgrp_01 = types.stoneSource,
			t_mw_terrrockbc_rockgrp_02 = types.stoneSource,
			t_mw_terrrockbc_rockgrp_03 = types.stoneSource,
			t_mw_terrrockbc_rockgrp_04 = types.stoneSource,
			t_mw_terrrockvm_rock_01 = types.stoneSource,
			t_mw_terrrockvm_rock_02 = types.stoneSource,
			t_mw_terrrockvm_rock_03 = types.stoneSource,
			t_mw_terrrockvm_rock_04 = types.stoneSource,
			t_mw_terrrockvm_rock_05 = types.stoneSource,
			t_mw_terrrockvm_rock_06 = types.stoneSource,
			t_mw_terrrockvm_rock_07 = types.stoneSource,
			t_mw_terrrockvm_rock_08 = types.stoneSource,
			t_mw_terrrockvm_rock_09 = types.stoneSource,
			t_mw_terrrockvm_rock_10 = types.stoneSource,
			t_mw_terrrockvm_rock_11 = types.stoneSource,
			t_mw_terrrockvm_rock_12 = types.stoneSource,
			t_mw_terrrockvm_rock_13 = types.stoneSource,
			t_mw_terrrockvm_rock_14 = types.stoneSource,
			t_mw_terrrockvm_rock_15 = types.stoneSource,
			t_mw_terrrockvm_rock_16 = types.stoneSource,
			t_mw_terrrockvm_rock_17 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_01 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_02 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_03 = types.stoneSource,
			t_mw_terrrockvm_rockgrp_04 = types.stoneSource,
			t_mw_terrrockgl_rock_19 = types.stoneSource,
			t_mw_terrrockgl_rock_20 = types.stoneSource,
			t_mw_terrrockgl_rock_21 = types.stoneSource,
			t_mw_terrrockgl_rock_22 = types.stoneSource,
			t_mw_terrrockgl_rock_23 = types.stoneSource,
			t_mw_terrrockgl_rock_24 = types.stoneSource,
			t_mw_terrrockgl_rock_25 = types.stoneSource,
			t_mw_terrrockgl_rock_26 = types.stoneSource,
			t_mw_terrrockgl_rock_27 = types.stoneSource,
			t_mw_terrrockgl_rock_28 = types.stoneSource,
			t_mw_terrrockgl_rock_29 = types.stoneSource,
			t_mw_terrrockgl_rock_30 = types.stoneSource,
			t_mw_terrrockgl_rock_31 = types.stoneSource,
			t_mw_terrrockgl_rock_32 = types.stoneSource,
			t_mw_terrrockgl_rock_33 = types.stoneSource,
			t_mw_terrrockgl_rock_34 = types.stoneSource,
			t_mw_terrrockgl_rock_35 = types.stoneSource,
			t_mw_terrrockgl_rock_36 = types.stoneSource,
			t_mw_terrrockrm_rock_01 = types.stoneSource,
			t_mw_terrrockrm_rock_02 = types.stoneSource,
			t_mw_terrrockrm_rock_03 = types.stoneSource,
			t_mw_terrrockrm_rock_04 = types.stoneSource,
			t_mw_terrrockrm_rock_05 = types.stoneSource,
			t_mw_terrrockow_rockgrp1_01 = types.stoneSource,
			t_mw_terrrockow_rockgrp1_02 = types.stoneSource,
			t_mw_terrrockow_rockgrp1_03 = types.stoneSource,
			t_mw_terrrockow_rockgrp1_04 = types.stoneSource,
			t_mw_terrrockow_rockgrp1_05 = types.stoneSource,
			t_mw_terrrockow_rockgrp1_06 = types.stoneSource,
			t_mw_terrrockow_rockgrp1_07 = types.stoneSource,
			t_mw_terrrockow_rockgrp2_01 = types.stoneSource,
			t_mw_terrrockow_rockgrp2_02 = types.stoneSource,
			t_mw_terrrockow_rockgrp2_03 = types.stoneSource,
			t_mw_terrrockow_rockgrp2_04 = types.stoneSource,
			t_mw_terrrockow_rockgrp2_05 = types.stoneSource,
			t_mw_terrrockow_rockgrp2_06 = types.stoneSource,
			t_mw_terrrockow_rockgrp2_07 = types.stoneSource,
			t_mw_terrrockrm_rockgrp_01 = types.stoneSource,
			t_mw_terrrockrm_rockgrp_02 = types.stoneSource,
			t_mw_terrrockrm_rockgrp_03 = types.stoneSource,
			t_mw_terrrockrm_rockgrp_04 = types.stoneSource,
			t_mw_terrrockrr_rockgrp_01 = types.stoneSource,
			t_mw_terrrockrr_rockgrp_02 = types.stoneSource,
			t_mw_terrrockrr_rockgrp_03 = types.stoneSource,
			t_mw_terrrockrr_rockgrp_04 = types.stoneSource,
			t_mw_terrrocksh_rockgrp2_01 = types.stoneSource,
			t_mw_terrrocksh_rockgrp2_02 = types.stoneSource,
			t_mw_terrrocksh_rockgrp2_03 = types.stoneSource,
			t_mw_terrrocksh_rockgrp2_04 = types.stoneSource,
			t_mw_terrrocksh_rockgrp2_05 = types.stoneSource,
			t_mw_terrrocksh_rockgrp2_06 = types.stoneSource,
			t_mw_terrrocksh_rockgrp2_07 = types.stoneSource,
			t_mw_terrrocksh_rockgrp3_01 = types.stoneSource,
			t_mw_terrrocksh_rockgrp3_02 = types.stoneSource,
			t_mw_terrrocksh_rockgrp3_03 = types.stoneSource,
			t_mw_terrrocksh_rockgrp3_04 = types.stoneSource,
			t_mw_terrrocksh_rockgrp3_05 = types.stoneSource,
			t_mw_terrrocksh_rockgrp3_06 = types.stoneSource,
			t_mw_terrrocksh_rockgrp3_07 = types.stoneSource,
			t_mw_terrrocksh_rockgrp1_01 = types.stoneSource,
			t_mw_terrrocksh_rockgrp1_02 = types.stoneSource,
			t_mw_terrrocksh_rockgrp1_03 = types.stoneSource,
			t_mw_terrrocksh_rockgrp1_04 = types.stoneSource,
			t_mw_terrrocksh_rockgrp1_05 = types.stoneSource,
			t_mw_terrrocksh_rockgrp1_06 = types.stoneSource,
			t_mw_terrrocksh_rockgrp1_07 = types.stoneSource,
			t_mw_terrrocktv_rockgrp_01 = types.stoneSource,
			t_mw_terrrocktv_rockgrp_02 = types.stoneSource,
			t_mw_terrrocktv_rockgrp_03 = types.stoneSource,
			t_mw_terrrocktv_rockgrp_04 = types.stoneSource,
			t_mw_terrrockwg_rock_01 = types.stoneSource,
			t_mw_terrrockwg_rock_02 = types.stoneSource,
			t_mw_terrrockwg_rock_03 = types.stoneSource,
			t_mw_terrrockwg_rock_04 = types.stoneSource,
			t_mw_terrrockwg_rock_05 = types.stoneSource,
			t_mw_terrrockwg_rock_06 = types.stoneSource,
			t_mw_terrrockwg_rock_07 = types.stoneSource,
			t_mw_terrrockwg_rock_08 = types.stoneSource,
		}

		ashfall.registerFoods{
			t_ingcrea_angelfish_01 = types.meat,
			t_ingcrea_duskyparrotfish_01 = types.meat,
			t_ingcrea_starfish_01 = types.meat,
			t_ingcrea_starfish_02 = types.meat,
			t_ingcrea_starfish_03 = types.meat,
			t_ingcrea_stridentbirdegg_01 = types.egg,
			t_ingcrea_sturgeonroe_01 = types.food,
			t_ingcrea_sturgeonmeat_01 = types.meat,
			t_ingcrea_barracudasteak_01 = types.meat,
			t_ingcrea_barracudatailfin_01 = types.meat,
			t_ingcrea_hoomegg_01 = types.egg,
			t_ingcrea_hoppermeat_01 = types.meat,
			t_ingcrea_kwoomegg_01 = types.egg,
			t_ingcrea_cetaceanmelon = types.meat,
			t_ingcrea_prawntail = types.meat,
			t_ingcrea_redsharkmeat_01 = types.meat,
			t_ingcrea_rocegg_01 = types.egg,
			t_ingcrea_seaurchinmeat_01 = types.meat,
			t_ingcrea_silverspademeat_01 = types.meat,
			t_ingcrea_tanthaegg_01 = types.egg,
			t_ingcrea_clammeat = types.meat,
			t_ingfood_breadbretonlong_01 = types.food,
			t_ingfood_breadbretonlong_02 = types.food,
			t_ingfood_breadbretonlong_03 = types.food,
			t_ingfood_breadkeptu_01 = types.food,
			t_ingfood_breadkeptu_02 = types.food,
			t_ingfood_breadkeptu_03 = types.food,
			t_ingfood_breadnordrye_01 = types.food,
			t_ingfood_breadnordrye_02 = types.food,
			t_ingfood_breadnordrye_03 = types.food,
			t_ingfood_breadredguard_01 = types.food,
			t_ingfood_breadredguard_02 = types.food,
			t_ingfood_breadredguard_03 = types.food,
			t_ingfood_cake_01 = types.food,
			t_ingfood_cheesebreton_01 = types.food,
			t_ingfood_cheesebreton_02 = types.food,
			t_ingfood_cheeseredguard_01 = types.food,
			t_ingfood_cracker_01 = types.food,
			t_ingfood_custtartredguard_01 = types.food,
			t_ingfood_eggseagull = types.egg,
			t_ingfood_hardtack_01 = types.food,
			t_ingfood_lottefruit_01 = types.vegetable,
			t_ingfood_marmongpaste_01 = types.food,
			t_ingfood_meatpork_01 = types.meat,
			t_ingfood_mokre_01 = types.seasoning,
			t_ingfood_noodlesesriwheat_01 = types.food,
			t_ingfood_noodlesynesairice_01 = types.food,
			t_ingfood_porridgepalm_01 = types.food,
			t_ingfood_ricecake_01 = types.food,
			t_ingfood_scone_01 = types.food,
			t_ingfood_sfiha_01 = types.food,
			t_ingfood_sfiha_02 = types.food,
			t_ingfood_tartredguard_01 = types.food,
			t_ingfood_vinegar_01 = types.seasoning,
			t_ingflor_macefruit_01 = types.vegetable,
			t_ingflor_maidenhair_01 = types.herb,
			t_ingflor_mindcap_01 = types.mushroom,
			t_ingflor_moosebite_01 = types.mushroom,
			t_ingflor_mountaindamask = types.herb,
			t_ingflor_ngoproot_01 = types.vegetable,
			t_ingflor_noddingstreakwort = types.herb,
			t_ingflor_padomaicsage_01 = types.herb,
			t_ingflor_pricklypear_01 = types.vegetable,
			t_ingflor_pilgrimgel_01 = types.food,
			t_ingflor_pilgrimpetals_01 = types.herb,
			t_ingflor_pitcher_01 = types.vegetable,
			t_ingflor_redgreenpepper_01 = types.vegetable,
			t_ingflor_rockburstclaw_01 = types.vegetable,
			t_ingflor_rougecamillea_01 = types.mushroom,
			t_ingflor_rustblossomseed_01 = types.herb,
			t_ingflor_seacup_01 = types.mushroom,
			t_ingflor_sujpod_01 = types.food,
			t_ingflor_sweetbreadpolypore_01 = types.mushroom,
			t_ingflor_swmpchal_01 = types.mushroom,
			t_ingflor_tigarafruit_01 = types.vegetable,
			t_ingflor_wispstalk_01 = types.mushroom,
			t_ingflor_woadfl_01 = types.herb,
			t_ingflor_yamorb_01 = types.vegetable,
			t_ingspice_anise_01 = types.seasoning,
			t_ingspice_cardamon_01 = types.seasoning,
			t_ingspice_cinnamon_01 = types.seasoning,
			t_ingspice_curcuma_01 = types.seasoning,
			t_ingspice_hibiscus_01 = types.seasoning,
			t_ingspice_muscat_01 = types.seasoning,
			t_ingspice_nigella_01 = types.seasoning,
			t_ingspice_oliveoil_01 = types.seasoning,
			t_ingspice_saffron_01 = types.seasoning,
			t_ingspice_pepper_01 = types.seasoning,
			t_ingcrea_meatdark_01 = types.meat,
			t_ingcrea_oystermeat_01 = types.meat,
			t_ingcrea_oystermeat_02 = types.meat,
			t_ingflor_alkanet_01 = types.herb,
			t_ingflor_aloeverapulp_01 = types.food,
			t_ingflor_anemictwinstipe_01 = types.mushroom,
			t_ingflor_aquilegia_01 = types.food,
			t_ingflor_arrowrootflower_01 = types.herb,
			t_ingflor_aspyrtea_01 = types.herb,
			t_ingflor_bearclaw_01 = types.herb,
			t_ingflor_bertpodslice_01 = types.meat,
			t_ingflor_bjoulsaerose_01 = types.herb,
			t_ingflor_blackrosepetal_01 = types.herb,
			t_ingflor_blacksporecap_01 = types.mushroom,
			t_ingflor_bleakbell_01 = types.herb,
			t_ingflor_blisteringfoment_01 = types.mushroom,
			t_ingflor_blisterspore_01 = types.herb,
			t_ingflor_blknet_01 = types.herb,
			t_ingflor_bloodgrass_01 = types.herb,
			t_ingflor_bloodlilyflower_01 = types.herb,
			t_ingflor_bloodlilypod_01 = types.herb,
			t_ingflor_bluefoot_01 = types.mushroom,
			t_ingflor_bogbeacon_01 = types.mushroom,
			t_ingflor_bottomweed_01 = types.herb,
			t_ingflor_cairnbolete_01 = types.mushroom,
			t_ingflor_canisroot_01 = types.herb,
			t_ingflor_carlineth_01 = types.herb,
			t_ingflor_chokeberry_01 = types.herb,
			t_ingflor_cinnabarpolypore_01 = types.mushroom,
			t_ingflor_cinnabarpolypore_02 = types.mushroom,
			t_ingflor_cloudedfunnel_01 = types.mushroom,
			t_ingflor_cowbell_01 = types.herb,
			t_ingflor_darksage_01 = types.herb,
			t_ingflor_deathbell_01 = types.herb,
			t_ingflor_desrosepetal_01 = types.herb,
			t_ingflor_domicaredwort_01 = types.herb,
			t_ingflor_dragynia_01 = types.herb,
			t_ingflor_dryadsaddle_01 = types.mushroom,
			t_ingflor_elfcup_01 = types.mushroom,
			t_ingflor_emeticrussula_01 = types.mushroom,
			t_ingflor_fennelseed_01 = types.herb,
			t_ingflor_fireflower_01 = types.herb,
			t_ingflor_flaxflower_01 = types.herb,
			t_ingflor_flaxflower_02 = types.herb,
			t_ingflor_flaxflower_03 = types.herb,
			t_ingflor_flyamanita_01 = types.mushroom,
			t_ingflor_forsythiatrroots_01 = types.herb,
			t_ingflor_foxglovenectar_01 = types.food,
			t_ingflor_ginseng_01 = types.herb,
			t_ingflor_glasswort_01 = types.herb,
			t_ingflor_goldenrod_01 = types.herb,
			t_ingflor_grasspod01 = types.herb,
			t_ingflor_greenstain_01 = types.mushroom,
			t_ingflor_greytickpowder_01 = types.mushroom,
			t_ingflor_hamumroot_01 = types.vegetable,
			t_ingflor_harrada_01 = types.vegetable,
			t_ingflor_hemlock_01 = types.herb,
			t_ingflor_hibiscus_01 = types.herb,
			t_ingflor_honeylily_01 = types.herb,
			t_ingflor_honeylily_02 = types.herb,
			t_ingflor_hyacinthnectar_01 = types.food,
			t_ingflor_icyshell01 = types.mushroom,
			t_ingflor_inkcone_01 = types.herb,
			t_ingflor_ironwoodnut_01 = types.herb,
			t_ingflor_jarmush_01 = types.herb,
			t_ingflor_kingbolete_01 = types.mushroom,
			t_ingflor_kingthistle_01 = types.herb,
			t_ingflor_ladysmantle_01 = types.herb,
			t_ingflor_ladyssmock_01 = types.herb,
			t_ingflor_lavender_01 = types.herb,
			t_ingflor_lichenblue_01 = types.herb,
			t_ingflor_lichenorange_01 = types.herb,
			t_ingflor_lichenwhite_01 = types.herb,
			t_ingflor_lichenyellow_01 = types.herb,
			t_ingflor_lizardfootextract_01 = types.food,
			t_ingflor_lotusseed_01 = types.herb,
			t_ingflor_mandrakeroot_01 = types.herb,
			t_ingflor_marasbeads_01 = types.herb,
			t_ingflor_marshstalk_01 = types.mushroom,
			t_ingflor_milkthistle_01 = types.herb,
			t_ingflor_mistletoe_01 = types.herb,
			t_ingflor_monardaseed_01 = types.herb,
			t_ingflor_monkshood_01 = types.herb,
			t_ingflor_monkshoodrootpulp_01 = types.food,
			t_ingflor_morningglory_01 = types.herb,
			t_ingflor_motherwort_01 = types.herb,
			t_ingflor_mustard_01 = types.herb,
			t_ingflor_nightshade_01 = types.herb,
			t_ingflor_nirnroot_01 = types.herb,
			t_ingflor_oleander_01 = types.herb,
			t_ingflor_orangemoss_01 = types.herb,
			t_ingflor_peony_01 = types.herb,
			t_ingflor_persarine_01 = types.herb,
			t_ingflor_plotusleaf_01 = types.herb,
			t_ingflor_primrose_01 = types.herb,
			t_ingflor_pyrousuracia = types.mushroom,
			t_ingflor_redpoppy_01 = types.herb,
			t_ingflor_rustrussula_01 = types.mushroom,
			t_ingflor_saltcrocuspetal_01 = types.herb,
			t_ingflor_saltstrapleaf_01 = types.herb,
			t_ingflor_saltstrappollen_01 = types.herb,
			t_ingflor_shadowfly_01 = types.herb,
			t_ingflor_shadowfly_02 = types.herb,
			t_ingflor_sheggoshelf_01 = types.mushroom,
			t_ingflor_siyat_01 = types.herb,
			t_ingflor_socatranectar_01 = types.food,
			t_ingflor_socratanectar_01 = types.food,
			t_ingflor_somnaliusfrond_01 = types.herb,
			t_ingflor_spongelotusseed_01 = types.herb,
			t_ingflor_steelblue_01 = types.mushroom,
			t_ingflor_stinkhorn_01 = types.mushroom,
			t_ingflor_stjahnswort_01 = types.herb,
			t_ingflor_sugarcane_01 = types.herb,
			t_ingflor_summerbolete_01 = types.mushroom,
			t_ingflor_tanna_01 = types.herb,
			t_ingflor_taragetis_01 = types.herb,
			t_ingflor_tawnyfunnelcap_01 = types.mushroom,
			t_ingflor_templedome_01 = types.mushroom,
			t_ingflor_thirrinelily_01 = types.herb,
			t_ingflor_thorntailberry_01 = types.vegetable,
			t_ingflor_thorntailflower_01 = types.herb,
			t_ingflor_thungleweed_01 = types.herb,
			t_ingflor_tigerlilynectar_01 = types.food,
			t_ingflor_tinderpolypore_01 = types.mushroom,
			t_ingflor_trembleweedsap_01 = types.herb,
			t_ingflor_trollroot_01 = types.vegetable,
			t_ingflor_turnip_01 = types.vegetable,
			t_ingflor_umbermorchella_01 = types.mushroom,
			t_ingflor_veiledurnula_01 = types.mushroom,
			t_ingflor_vicarherb_01 = types.herb,
			t_ingflor_vilemorchella_01 = types.mushroom,
			t_ingflor_viperbugloss_01 = types.herb,
			t_ingflor_weepveil_01 = types.mushroom,
			t_ingflor_widowkisspowder_01 = types.herb,
			t_ingflor_wormwood_01 = types.herb,
			t_ingflor_wtlillypurple_01 = types.herb,
			t_ingfood_altachipear_01 = types.vegetable,
			t_ingfood_apple_01 = types.vegetable,
			t_ingfood_appleskyrim_01 = types.vegetable,
			t_ingfood_blackberry_01 = types.vegetable,
			t_ingfood_blueberry_01 = types.vegetable,
			t_ingfood_bread_01 = types.food,
			t_ingfood_bread_02 = types.food,
			t_ingfood_bread_03 = types.food,
			t_ingfood_breadcolovian_01 = types.food,
			t_ingfood_breadcolovian_02 = types.food,
			t_ingfood_breadcolovianmw_01 = types.food,
			t_ingfood_breadcolovianmw_02 = types.food,
			t_ingfood_breaddeshaan_01 = types.food,
			t_ingfood_breaddeshaan_02 = types.food,
			t_ingfood_breaddeshaan_03 = types.food,
			t_ingfood_breaddeshaan_04 = types.food,
			t_ingfood_breaddeshaan_05 = types.food,
			t_ingfood_breadflat_01 = types.food,
			t_ingfood_breadflat_02 = types.food,
			t_ingfood_breadflat_03 = types.food,
			t_ingfood_bridethornberry_01 = types.vegetable,
			t_ingfood_carrot_01 = types.vegetable,
			t_ingfood_cheesecolovian_01 = types.food,
			t_ingfood_cheesenord_01 = types.food,
			t_ingfood_cheesewheelnord_01 = types.food,
			t_ingfood_cheesewheelnord_02 = types.food,
			t_ingfood_cloudycorn_01 = types.vegetable,
			t_ingfood_cookie_01 = types.food,
			t_ingfood_cookie_02 = types.food,
			t_ingfood_eggchicken_01 = types.egg,
			t_ingfood_eggmolecrab_01 = types.egg,
			t_ingfood_eggornada_01 = types.egg,
			t_ingfood_riverstrideregg_01 = types.egg,
			t_ingfood_fig_01 = types.vegetable,
			t_ingfood_fig_dried_01 = types.food,
			t_ingfood_fishbrowntrout_01 = types.meat,
			t_ingfood_fishchrysophant_01 = types.meat,
			t_ingfood_fishcod_01 = types.meat,
			t_ingfood_fishcoddried_01 = types.food,
			t_ingfood_fishleapertail_01 = types.meat,
			t_ingfood_fishlongfinfilet_01 = types.meat,
			t_ingfood_fishpike_01 = types.meat,
			t_ingfood_fishpikeperch_01 = types.meat,
			t_ingfood_fishsalmon_01 = types.meat,
			t_ingfood_fishslaughterdried_01 = types.food,
			t_ingfood_fishslaughterdried_02 = types.food,
			t_ingfood_fishslaughterdried_03 = types.food,
			t_ingfood_fishslaughterdried_04 = types.food,
			t_ingfood_fishspr_01 = types.meat,
			t_ingfood_fishstrid_01 = types.meat,
			t_ingfood_flour_01 = types.vegetable,
			t_ingfood_garlic_01 = types.vegetable,
			t_ingfood_gooseb01 = types.vegetable,
			t_ingfood_gorapple_01 = types.vegetable,
			t_ingfood_grape_01 = types.vegetable,
			t_ingfood_grape_02 = types.vegetable,
			t_ingfood_grapewrothgarian_01 = types.vegetable,
			t_ingfood_honey_01 = types.food,
			t_ingfood_indureta_01 = types.vegetable,
			t_ingfood_ironrye_01 = types.vegetable,
			t_ingfood_leek_01 = types.vegetable,
			t_ingfood_lyco_01 = types.food,
			t_ingfood_mango_01 = types.food,
			t_ingfood_meatalit_01 = types.meat,
			t_ingfood_meatarenthjerky_01 = types.food,
			t_ingfood_meatbeef_01 = types.meat,
			t_ingfood_meatboar_01 = types.meat,
			t_ingfood_meatboar_02 = types.meat,
			t_ingfood_meatboarroast_02 = types.cookedMeat,
			t_ingfood_meatchicken_01 = types.meat,
			t_ingfood_meatchickenroast_01 = types.cookedMeat,
			t_ingfood_meatcliffracer_01 = types.meat,
			t_ingfood_meatdolphin_01 = types.meat,
			t_ingfood_meatdurzog_01 = types.cookedMeat,
			t_ingfood_meatguar_01 = types.meat,
			t_ingfood_meatham_01 = types.meat,
			t_ingfood_meathorker_01 = types.meat,
			t_ingfood_meathorse_01 = types.meat,
			t_ingfood_meatkagouti_01 = types.meat,
			t_ingfood_meatkwama_01 = types.meat,
			t_ingfood_meatmutton_01 = types.meat,
			t_ingfood_meatnixhoundroast_01 = types.cookedMeat,
			t_ingfood_meatornada_01 = types.meat,
			t_ingfood_meatparastylus_01 = types.meat,
			t_ingfood_meatrat_01 = types.cookedMeat,
			t_ingfood_meatratroast_01 = types.cookedMeat,
			t_ingfood_meatsqrl_01 = types.meat,
			t_ingfood_meatvenison_01 = types.meat,
			t_ingfood_meatvenisonroast_01 = types.cookedMeat,
			t_ingfood_olives_01 = types.vegetable,
			t_ingfood_onion_01 = types.vegetable,
			t_ingfood_passionfruit_01 = types.vegetable,
			t_ingfood_plum_01 = types.vegetable,
			t_ingfood_pomegranate_01 = types.vegetable,
			t_ingfood_poppadgourd_01 = types.vegetable,
			t_ingfood_potato_01 = types.vegetable,
			t_ingfood_radish_01 = types.vegetable,
			t_ingfood_rice_01 = types.vegetable,
			t_ingfood_scribpie_01 = types.food,
			t_ingfood_silverpalmfruit_01 = types.vegetable,
			t_ingfood_snowberry_01 = types.vegetable,
			t_ingfood_strawberry_01 = types.vegetable,
			t_ingfood_sweetroll_01 = types.food,
			t_ingfood_tomato_01 = types.vegetable,
			t_ingfood_trinityfruit_01 = types.vegetable,
			t_ingfood_wasabipowder_01 = types.food,
			t_ingfood_wasabiroot_01 = types.vegetable,
			t_ingfood_wheat_01 = types.vegetable,
			t_ingmine_salt_01 = types.seasoning,
		}

		ashfall.registerWaterContainers{
			t_arg_ceramicbottle_01 = { capacity = 90 },
			t_arg_ceramicbottle_02 = { capacity = 90 },
			t_arg_ceramiccup_01 = { capacity = 25 },
			t_arg_ceramiccup_02 = { capacity = 25 },
			t_arg_ceramicjug_01 = { capacity = 200 },
			t_arg_ceramicjug_02 = { capacity = 200 },
			t_arg_ceramicpitcher_01 = { capacity = 190 },
			t_arg_ceramicpitcher_02 = { capacity = 190 },
			t_arg_ceramicpot_01 = {  holdsStew = true, capacity = 100 },
			t_arg_ceramicpot_02 = {  holdsStew = true, capacity = 100 },
			t_arg_woodenbowl_01 = { capacity = 60, holdsStew = true },
			t_arg_woodenbowl_02 = { capacity = 60, holdsStew = true },
			t_arg_woodenbowl_03 = { capacity = 60, holdsStew = true },
			t_arg_woodencup_01 = { capacity = 25 },
			t_arg_woodencup_02 = { capacity = 25 },
			t_arg_woodencup_03 = { capacity = 25 },
			t_arg_woodenflask_01 = {  capacity = 80 },
			t_arg_woodenjar_01 = { holdsStew = true, capacity = 100 },
			t_arg_woodenpitcher_01 = { capacity = 190 },
			t_arg_woodenpot_01 = {  holdsStew = true, capacity = 100 },
			t_ayl_claybowl_01 = { capacity = 60, holdsStew = true },
			t_ayl_claybowl_02 = { capacity = 60, holdsStew = true },
			t_ayl_claybowl_03 = { capacity = 60, holdsStew = true },
			t_ayl_claycup_01 = { capacity = 25 },
			t_ayl_clayjar_01 = { holdsStew = true, capacity = 100 },
			t_ayl_clayjar_02 = { holdsStew = true, capacity = 100 },
			t_ayl_claypot_01 = {  holdsStew = true, capacity = 100 },
			t_ayl_claypot_02 = {  holdsStew = true, capacity = 100 },
			t_ayl_goblet_01 = {  capacity = 25 },
			t_bre_bottle_01 = { capacity = 90 },
			t_bre_bottle_02 = { capacity = 90 },
			t_bre_bottle_03 = { capacity = 200 },
			t_bre_bottle_04 = { holdsStew = true, capacity = 100 },
			t_bre_bottle_05 = { capacity = 90 },
			t_bre_bottle_06 = { capacity = 90 },
			t_bre_bottle_07 = { capacity = 200 },
			t_bre_bottle_08 = { holdsStew = true, capacity = 100 },
			t_bre_bottle_09 = { capacity = 90 },
			t_bre_bottle_10 = { capacity = 90 },
			t_bre_bottle_11 = { capacity = 200 },
			t_bre_bottle_12 = { holdsStew = true, capacity = 100 },
			t_bre_bottle_13 = { capacity = 90 },
			t_bre_bottle_14 = { capacity = 90 },
			t_bre_bottle_15 = { capacity = 200 },
			t_bre_bottle_16 = { holdsStew = true, capacity = 100 },
			t_bre_claybowl_01 = { capacity = 60, holdsStew = true },
			t_bre_claybowl_02 = { capacity = 60, holdsStew = true },
			t_bre_claycup_01 = { capacity = 25 },
			t_bre_claycup_02 = { capacity = 25 },
			t_bre_clayjug_01 = { capacity = 200 },
			t_bre_claypitcher_01 = { capacity = 190 },
			t_bre_clayvase_01 = { capacity = 200 },
			t_bre_greenglassbeaker_01 = {  capacity = 25 },
			t_bre_greenglassbowl_01 = { capacity = 60, holdsStew = true },
			t_bre_greenglasscup_01 = { capacity = 25 },
			t_bre_greenglassflask_01 = {  capacity = 80 },
			t_bre_greenglassgoblet_01 = {  capacity = 25 },
			t_bre_greenglasspitcher_01 = { capacity = 190 },
			t_bre_greenglasspot_01 = {  holdsStew = true, capacity = 100 },
			t_bre_greenglasspot_02 = {  holdsStew = true, capacity = 100 },
			t_bre_greenglassvase_01 = { capacity = 200 },
			t_bre_greenglassvase_02 = { capacity = 200 },
			t_bre_greenglassvase_03 = { capacity = 200 },
			t_bre_pewterbowl_01 = { capacity = 60, holdsStew = true },
			t_bre_pewterbowl_02 = { capacity = 60, holdsStew = true },
			t_bre_pewtercup_01 = { capacity = 25 },
			t_bre_pewtercup_02 = { capacity = 25 },
			t_bre_pewtergoblet_01 = {  capacity = 25 },
			t_bre_pewterpot_01 = {  holdsStew = true, capacity = 100 },
			t_bre_pewterpot_02 = {  holdsStew = true, capacity = 100 },
			t_bre_pewtervase_01 = { capacity = 200 },
			t_bre_redglassbowl_01 = { capacity = 60, holdsStew = true },
			t_bre_redglassbowl_02 = { capacity = 60, holdsStew = true },
			t_bre_redglasscup_01 = { capacity = 25 },
			t_bre_redglassgoblet_01 = {  capacity = 25 },
			t_bre_redglasspitcher_01 = { capacity = 190 },
			t_bre_redglasspot_01 = {  holdsStew = true, capacity = 100 },
			t_bre_redglassvase_01 = { capacity = 200 },
			t_bre_stonewarebowl_01 = { capacity = 60, holdsStew = true },
			t_bre_stonewarebowl_02 = { capacity = 60, holdsStew = true },
			t_bre_stonewarecup_01 = { capacity = 25 },
			t_bre_stonewarecup_02 = { capacity = 25 },
			t_bre_stonewareflask_01 = {  capacity = 80 },
			t_bre_stonewarejar_01 = { holdsStew = true, capacity = 100 },
			t_bre_stonewarepitcher_01 = { capacity = 190 },
			t_bre_stonewarevase_01 = { capacity = 200 },
			t_bre_woodbowl_01 = { capacity = 60, holdsStew = true },
			t_bre_woodbowl_02 = { capacity = 60, holdsStew = true },
			t_bre_woodbowl_03 = { capacity = 60, holdsStew = true },
			t_bre_woodbowl_04 = { capacity = 60, holdsStew = true },
			t_bre_woodcup_01 = { capacity = 25 },
			t_bre_woodcup_02 = { capacity = 25 },
			t_com_bottlered_01 = { capacity = 90 },
			t_com_bottlered_02 = { capacity = 90 },
			t_com_bottlered_03 = { capacity = 90 },
			t_com_bottlered_04 = { capacity = 90 },
			t_com_bottlered_05 = { capacity = 200 },
			t_com_coconutbowl_01 = { capacity = 60, holdsStew = true },
			t_com_coconutbowl_02 = { capacity = 60, holdsStew = true },
			t_com_coconutbowl_03 = { capacity = 60, holdsStew = true },
			t_com_coconutcup_01 = { capacity = 25 },
			t_com_coconutcup_02 = { capacity = 25 },
			t_com_impcanteen = {  capacity = 80 },
			t_com_potionbottle_01 = { capacity = 90, weight = 4 },
			t_com_potionbottle_02 = { capacity = 90, weight = 4 },
			t_com_potionbottle_03 = { capacity = 90, weight = 4 },
			t_com_potionbottle_04 = { capacity = 90, weight = 4 },
			t_com_tankard_01 = {  capacity = 30 },
			t_com_uni_large_mug_01 = {  capacity = 30 },
			t_com_woodbowl_a01 = { capacity = 60, holdsStew = true },
			t_com_woodbowl_a02 = { capacity = 60, holdsStew = true },
			t_com_woodbowl_b01 = { capacity = 60, holdsStew = true },
			t_com_woodbowl_b02 = { capacity = 60, holdsStew = true },
			t_com_woodbowl_c01 = { capacity = 60, holdsStew = true },
			t_com_woodbowl_c02 = { capacity = 60, holdsStew = true },
			t_com_woodbowl_c03 = { capacity = 60, holdsStew = true },
			t_com_woodcup_a01 = { capacity = 25 },
			t_com_woodcup_a02 = { capacity = 25 },
			t_com_woodcup_c01 = { capacity = 25 },
			t_com_woodcup_c02 = { capacity = 25 },
			t_com_woodencup_01 = { capacity = 25 },
			t_de_blueglassbowl_01 = { capacity = 60, holdsStew = true },
			t_de_blueglasscup_01 = { capacity = 25 },
			t_de_bluewareflask01 = {  capacity = 80 },
			t_de_bluewareflask02 = {  capacity = 80 },
			t_de_blueglassglass_01  = {  capacity = 80 },
			t_de_bluewarecup01 = { capacity = 25 },
			t_de_bluewaretankard01 = {  capacity = 30 },
			t_de_bluewarevase01 = { capacity = 200 },
			t_de_claybowl01 = { capacity = 60, holdsStew = true },
			t_de_claycup01 = { capacity = 25 },
			t_de_clayflask01 = {  capacity = 80 },
			t_de_ebony_bowl_01 = { capacity = 60, holdsStew = true },
			t_de_ebony_bowl_02 = { capacity = 60, holdsStew = true },
			t_de_ebony_cup_01 = { capacity = 25 },
			t_de_ebony_flask_01 = {  capacity = 80 },
			t_de_ebony_largeflask_01 = {  capacity = 80 },
			t_de_greenglassbowl_01 = { capacity = 60, holdsStew = true },
			t_de_greenglassbowl_02 = { capacity = 60, holdsStew = true },
			t_de_greenglasscup_01 = { capacity = 25 },
			t_de_greenglasspitcher_01 = { capacity = 190 },
			t_de_greenglasspot_01 = {  holdsStew = true, capacity = 100 },
			t_de_greydust_vial = {  capacity = 25 },
			t_de_orangegreencup_01 = { capacity = 25 },
			t_de_orangegreenflask_01 = {  capacity = 80 },
			t_de_orangegreenpot_01 = {  holdsStew = true, capacity = 100 },
			t_de_peachglasscup_01 = { capacity = 25 },
			t_de_punavitcup_01 = { capacity = 25 },
			t_de_purpleglassbowl_01 = { capacity = 60, holdsStew = true },
			t_de_purpleglassbowl_02 = { capacity = 60, holdsStew = true },
			t_de_purpleglassbowl_03 = { capacity = 60, holdsStew = true },
			t_de_purpleglasscup_01 = { capacity = 25 },
			t_de_purpleglasscup_02 = { capacity = 25 },
			t_de_purpleglassflask_01 = {  capacity = 80 },
			t_de_purpleglassflask_02 = {  capacity = 80 },
			t_de_purpleglasspot_01 = {  holdsStew = true, capacity = 100 },
			t_de_purpleglasspot_02 = {  holdsStew = true, capacity = 100 },
			t_de_stonewarebowl_01 = { capacity = 60, holdsStew = true },
			t_de_stonewarebowl_02 = { capacity = 60, holdsStew = true },
			t_de_stonewarebowl_03 = { capacity = 60, holdsStew = true },
			t_de_stonewarecup_01 = { capacity = 25 },
			t_de_stonewarecup_02 = { capacity = 25 },
			t_de_stonewarejug_01 = { capacity = 200 },
			t_de_stonewarepitcher_01 = { capacity = 190 },
			t_de_stonewarepot_01 = {  holdsStew = true, capacity = 100 },
			t_de_stonewarepot_02 = {  holdsStew = true, capacity = 100 },
			t_de_stonewarepot_03 = {  holdsStew = true, capacity = 100 },
			t_de_telvannitankard_01 = {  capacity = 30 },
			t_de_waterskin_01 = { capacity = 90 },
			t_de_yellowglassbowl01 = { capacity = 60, holdsStew = true },
			t_de_yellowglasscup01 = { capacity = 25 },
			t_de_yellowglassflask01 = {  capacity = 80 },
			t_de_yellowglasspot01 = {  holdsStew = true, capacity = 100 },
			t_he_blueceladonbowl_01 = { capacity = 60, holdsStew = true },
			t_he_blueceladoncup_01 = { capacity = 25 },
			t_he_blueceladonpot_01 = {  holdsStew = true, capacity = 100 },
			t_he_blueceladonvase_01 = { capacity = 200 },
			t_he_blueceladonvase_02 = { capacity = 200 },
			t_he_blueceladonvase_03 = { capacity = 200 },
			t_he_bluewarebowl_01 = { capacity = 60, holdsStew = true },
			t_he_bluewarecup_01 = { capacity = 25 },
			t_he_bluewarepitcher_01 = { capacity = 190 },
			t_he_bluewarepot_01 = {  holdsStew = true, capacity = 100 },
			t_he_bluewarepot_02 = {  holdsStew = true, capacity = 100 },
			t_he_bluewarevase_01 = { capacity = 200 },
			t_he_bluewarevase_02 = { capacity = 200 },
			t_he_bottle_01 = { capacity = 90 },
			t_he_bottle_02 = { capacity = 90 },
			t_he_bottle_03 = { capacity = 90 },
			t_he_bottle_04 = { capacity = 90 },
			t_he_bottle_05 = { capacity = 200 },
			t_he_bottle_06 = { capacity = 90 },
			t_he_bottle_07 = { capacity = 90 },
			t_he_bottle_08 = { capacity = 90 },
			t_he_bottle_09 = { capacity = 90 },
			t_he_bottle_10 = { capacity = 200 },
			t_he_bottle_11 = { capacity = 90 },
			t_he_bottle_12 = { capacity = 90 },
			t_he_bottle_13 = { capacity = 90 },
			t_he_bottle_14 = { capacity = 90 },
			t_he_bottle_15 = { capacity = 200 },
			t_he_dirennibowl_01 = { capacity = 60, holdsStew = true },
			t_he_dirennicup_01 = { capacity = 25 },
			t_he_dirennicup_02 = { capacity = 25 },
			t_he_direnniflask_01a = {  capacity = 80 },
			t_he_direnniflask_02a = {  capacity = 80 },
			t_he_direnniflask_03a = {  capacity = 80 },
			t_he_direnniflask_04a = {  capacity = 80 },
			t_he_direnniflask_05a = {  capacity = 80 },
			t_he_direnniflask_06a = {  capacity = 80 },
			t_he_direnniflask_07a = {  capacity = 80 },
			t_he_direnniflask_07b = {  capacity = 80 },
			t_he_dirennigoblet_01 = {  capacity = 25 },
			t_he_dirennipitcher_01 = { capacity = 190 },
			t_he_dirennipot_01 = {  holdsStew = true, capacity = 100 },
			t_he_dirennipot_02 = {  holdsStew = true, capacity = 100 },
			t_he_dirennipot_03 = {  holdsStew = true, capacity = 100 },
			t_he_dirennipot_04 = {  holdsStew = true, capacity = 100 },
			t_he_dirennivase_01 = { capacity = 200 },
			t_he_glassblubowl01 = { capacity = 30, holdsstew = true },
			t_he_glassblubowl02 = { capacity = 30, holdsstew = true },
			t_he_glassblubowl03 = { capacity = 30, holdsstew = true },
			t_he_glassblucup01 = { capacity = 25 },
			t_he_glassyelbowl01 = { capacity = 30, holdsstew = true },
			t_he_glassyelbowl02 = { capacity = 30, holdsstew = true },
			t_he_glassyelcup01 = { capacity = 25 },
			t_he_greenceladonbowl_01 = { capacity = 60, holdsStew = true },
			t_he_greenceladoncup_01 = { capacity = 25 },
			t_he_greenceladonpot_01 = {  holdsStew = true, capacity = 100 },
			t_he_greenceladonvase_01 = { capacity = 200 },
			t_he_greenceladonvase_02 = { capacity = 200 },
			t_he_greenceladonvase_03 = { capacity = 200 },
			t_he_nacrebowl_01 = { capacity = 60, holdsstew = true },
			t_he_nacrecup_01 = { capacity = 25 },
			t_he_nacregoblet_01 = { capacity = 25 },
			t_he_shellbowl_01 = { capacity = 30, holdsstew = true },
			t_he_shellbowl_02 = { capacity = 30, holdsstew = true },
			t_imp_carvedwoodbowl_01 = { capacity = 60, holdsStew = true },
			t_imp_carvedwoodcup_01 = { capacity = 25 },
			t_imp_carvedwoodvessel_01 = {  holdsStew = true, capacity = 100 },
			t_imp_colbarrowclaybowl_01 = { capacity = 60, holdsStew = true },
			t_imp_colbarrowclaycup_01 = { capacity = 25 },
			t_imp_colbarrowclayflask_01 = {  capacity = 80 },
			t_imp_colbarrowclaypitcher_01 = { capacity = 190 },
			t_imp_colbarrowbowl_01 = { capacity = 60, holdsStew = true },
			t_imp_colbarrowchalice_01 = {  capacity = 25 },
			t_imp_colbarrowgoblet_01 = {  capacity = 25 },
			t_imp_colbarrowjar_01 = { holdsStew = true, capacity = 100 },
			t_imp_colbarrowjar_02 = { holdsStew = true, capacity = 100 },
			t_imp_colclaybottle_01 = { capacity = 190 },
			t_imp_colclaybowl_01 = { capacity = 60, holdsStew = true },
			t_imp_colclaycup_01 = { capacity = 25 },
			t_imp_colclaypot_01 = { capacity = 200 },
			t_imp_colclaypot_02 = {  holdsstew = true, capacity = 100 },
			t_imp_goldbottle_01 = { capacity = 90 },
			t_imp_goldbowl_01 = { capacity = 60, holdsstew = true },
			t_imp_goldbowl_02 = { capacity = 60, holdsstew = true },
			t_imp_goldbowl_03 = { capacity = 60, holdsstew = true },
			t_imp_goldbowl_04 = { capacity = 60, holdsstew = true },
			t_imp_goldcup_01 = { capacity = 25 },
			t_imp_goldgoblet_01 = {  capacity = 25 },
			t_imp_goldpitcher_01 = { capacity = 190 },
			t_imp_silverwarebottle_01 = { capacity = 90 },
			t_imp_silverwarecup_01 = { capacity = 25 },
			t_imp_silverwarecup_02 = { capacity = 25 },
			t_imp_silverwarecup_03 = { capacity = 25 },
			t_imp_silverwarepot_01 = {  holdsStew = true, capacity = 100 },
			t_imp_silverwarepot_02 = {  holdsStew = true, capacity = 100 },
			t_imp_silverwaretankard_01 = {  capacity = 30 },
			t_imp_silverwarevase_01 = { capacity = 200 },
			t_imp_tankardnavy_01 = {  capacity = 30 },
			t_ned_mw_bowl = { capacity = 60, holdsStew = true },
			t_ned_mw_pitcher = { capacity = 190 },
			t_ned_mw_pot = {  holdsStew = true, capacity = 100 },
			t_nor_ceramicbowl_01 = { capacity = 60, holdsStew = true },
			t_nor_ceramicbowl_02 = { capacity = 60, holdsStew = true },
			t_nor_ceramicbowl_03 = { capacity = 60, holdsStew = true },
			t_nor_claypot_01 = {  holdsStew = true, capacity = 100 },
			t_nor_claypot_02 = {  holdsStew = true, capacity = 100 },
			t_nor_coppertankard = {  capacity = 30 },
			t_nor_drinkinghorn_01 = { capacity = 30 },
			t_nor_drinkinghorn_02 = { capacity = 30 },
			t_nor_drinkinghorn_03 = { capacity = 30 },
			t_nor_flaskblue_01 = {  capacity = 80 },
			t_nor_flaskblue_02 = {  capacity = 80 },
			t_nor_flaskblue_03 = {  capacity = 80 },
			t_nor_flaskblue_04 = {  capacity = 80 },
			t_nor_flaskgreen_01 = {  capacity = 80 },
			t_nor_flaskgreen_02 = {  capacity = 80 },
			t_nor_flaskgreen_03 = {  capacity = 80 },
			t_nor_flaskgreen_04 = {  capacity = 80 },
			t_nor_flaskred_01 = {  capacity = 80 },
			t_nor_flaskred_02 = {  capacity = 80 },
			t_nor_flaskred_03 = {  capacity = 80 },
			t_nor_flaskred_04 = {  capacity = 80 },
			t_nor_ironwoodbowl_01 = { capacity = 60, holdsStew = true },
			t_nor_ironwoodgoblet_01 = {  capacity = 25 },
			t_nor_ironwoodtankard_01 = {  capacity = 30 },
			t_nor_ironwoodvase_01 = { capacity = 200 },
			t_nor_ironwoodvase_02 = { capacity = 200 },
			t_nor_potionbagemptypoor_01 = { capacity = 30 },
			t_nor_silverbowl_01 = { capacity = 60, holdsStew = true },
			t_nor_silverbowl_02 = { capacity = 60, holdsStew = true },
			t_nor_silvergoblet_01 = {  capacity = 25 },
			t_nor_silvervase_01 = { capacity = 200 },
			t_nor_silvervase_02 = { capacity = 200 },
			t_nor_woodenbowl_01a = { capacity = 60, holdsStew = true },
			t_nor_woodenbowl_01b = { capacity = 60, holdsStew = true },
			t_nor_woodenbowl_02a = { capacity = 60, holdsStew = true },
			t_nor_woodenbowl_02b = { capacity = 60, holdsStew = true },
			t_nor_woodenbowl_03a = { capacity = 60, holdsStew = true },
			t_nor_woodenbowl_03b = { capacity = 60, holdsStew = true },
			t_nor_woodenbowl_04a = { capacity = 60, holdsStew = true },
			t_nor_woodenbowl_04b = { capacity = 60, holdsStew = true },
			t_nor_woodengoblet_01a = {  capacity = 25 },
			t_nor_woodengoblet_01b = {  capacity = 25 },
			t_nor_woodengoblet_01c = {  capacity = 25 },
			t_nor_woodengoblet_02a = {  capacity = 25 },
			t_nor_woodengoblet_02b = {  capacity = 25 },
			t_nor_woodengoblet_03a = {  capacity = 25 },
			t_nor_woodengoblet_03b = {  capacity = 25 },
			t_nor_woodengoblet_04a = {  capacity = 25 },
			t_nor_woodengoblet_04b = {  capacity = 25 },
			t_nor_woodenpot_01a = {  holdsStew = true, capacity = 100 },
			t_nor_woodenpot_01b = {  holdsStew = true, capacity = 100 },
			t_nor_woodenpot_02a = {  holdsStew = true, capacity = 100 },
			t_nor_woodenpot_02b = {  holdsStew = true, capacity = 100 },
			t_nor_woodenpot_03a = {  holdsStew = true, capacity = 100 },
			t_nor_woodenpot_03b = {  holdsStew = true, capacity = 100 },
			t_nor_woodentankard_01a = {  capacity = 30 },
			t_nor_woodentankard_01b = {  capacity = 30 },
			t_qy_bottle_01a = { capacity = 90 },
			t_qy_bottle_01b = { capacity = 90 },
			t_qy_bottle_01c = { capacity = 90 },
			t_qy_bottle_01d = { capacity = 90 },
			t_qy_bottle_02a = { capacity = 90 },
			t_qy_bottle_02b = { capacity = 90 },
			t_qy_bottle_02c = { capacity = 90 },
			t_qy_bottle_02d = { capacity = 90 },
			t_qy_bronzebowl_01 = { capacity = 60, holdsStew = true },
			t_qy_bronzebowl_02 = { capacity = 60, holdsStew = true },
			t_qy_bronzebowl_03 = { capacity = 60, holdsStew = true },
			t_qy_bronzecup_01 = { capacity = 25 },
			t_qy_bronzecup_02 = { capacity = 25 },
			t_qy_bronzepitcher_01 = { capacity = 190 },
			t_qy_bronzevase_01 = { capacity = 200 },
			t_qy_bronzevase_02 = { capacity = 200 },
			t_qy_bronzevase_03 = { capacity = 200 },
			t_qy_palmwoodbowl_01 = { capacity = 60, holdsStew = true },
			t_qy_palmwoodbowl_02 = { capacity = 60, holdsStew = true },
			t_qy_palmwoodbowl_03 = { capacity = 60, holdsStew = true },
			t_qy_palmwoodcup_01 = { capacity = 25 },
			t_qy_palmwoodcup_02 = { capacity = 25 },
			t_qy_palmwoodpitcher_01 = { capacity = 190 },
			t_qy_palmwoodpot = {  holdsStew = true, capacity = 100 },
			t_qy_redglassbowl_01 = { capacity = 60, holdsStew = true },
			t_qy_redglassbowl_02 = { capacity = 60, holdsStew = true },
			t_qy_redglassbowl_03 = { capacity = 60, holdsStew = true },
			t_qy_redglasscup_01 = { capacity = 25 },
			t_qy_redglasscup_02 = { capacity = 25 },
			t_qy_redglasspitcher = { capacity = 190 },
			t_qy_redglassvase = { capacity = 200 },
			t_qyk_ceramicbowl_01 = { capacity = 60, holdsStew = true },
			t_qyk_ceramicbowl_02 = { capacity = 60, holdsStew = true },
			t_qyk_ceramicbowl_03 = { capacity = 60, holdsStew = true },
			t_qyk_ceramiccup_01 = { capacity = 25 },
			t_qyk_ceramiccup_02 = { capacity = 25 },
			t_qyk_ceramicpitcher = { capacity = 190 },
			t_qyk_ceramicvase_01 = { capacity = 200 },
			t_qyk_ceramicvase_02 = { capacity = 200 },
			t_qyc_shellwarebowl_01 = { capacity = 60, holdsStew = true },
			t_qyc_shellwarebowl_02 = { capacity = 60, holdsStew = true },
			t_qyc_shellwarebowl_03 = { capacity = 60, holdsStew = true },
			t_qyc_shellwarecup_01 = { capacity = 25 },
			t_qyc_shellwarecup_02 = { capacity = 25 },
			t_qyc_shellwarepitcher = { capacity = 190 },
			t_qyc_shellwarevase_01 = { capacity = 200 },
			t_qyc_shellwarevase_02 = { capacity = 200 },
			t_rga_blackwarebowl_01 = { capacity = 60, holdsStew = true },
			t_rga_blackwarecup_01 = { capacity = 25 },
			t_rga_bottle_01 = { capacity = 90 },
			t_rga_bottle_02 = { capacity = 90 },
			t_rga_bottle_03 = { capacity = 90 },
			t_rga_bottle_04 = { capacity = 90 },
			t_rga_bottle_05 = { capacity = 200 },
			t_rga_bottle_06 = { capacity = 200 },
			t_rga_bottle_07 = { capacity = 90 },
			t_rga_bottle_08 = { capacity = 200 },
			t_rga_bottle_09 = { capacity = 90 },
			t_rga_bottle_10 = { capacity = 200 },
			t_rga_bottle_11 = { capacity = 90 },
			t_rga_bottle_12 = { capacity = 90 },
			t_rga_bottle_13 = { capacity = 90 },
			t_rga_bottle_14 = { capacity = 90 },
			t_rga_bottle_15 = { capacity = 200 },
			t_rga_bottle_16 = { capacity = 200 },
			t_rga_bottle_17 = { capacity = 90 },
			t_rga_bottle_18 = { capacity = 200 },
			t_rga_bottle_19 = { capacity = 90 },
			t_rga_bottle_20 = { capacity = 200 },
			t_rga_claybowl_01 = { capacity = 60, holdsStew = true },
			t_rga_claybowl_02 = { capacity = 60, holdsStew = true },
			t_rga_claybowl_03 = { capacity = 60, holdsStew = true },
			t_rga_claycup_01 = { capacity = 25 },
			t_rga_claycup_02 = { capacity = 25 },
			t_rga_claycup_03 = { capacity = 25 },
			t_rga_clayflask_01 = {  capacity = 80 },
			t_rga_claypitcher_01 = { capacity = 190 },
			t_rga_claypot_01 = {  holdsStew = true, capacity = 100 },
			t_rga_glasswarebowl_01 = { capacity = 60, holdsStew = true },
			t_rga_glasswarebowl_02 = { capacity = 60, holdsStew = true },
			t_rga_flask_01 = {  capacity = 80 },
			t_rga_pitcher_01 = { capacity = 190 },
			t_rga_porcelainbowl_01 = { capacity = 60, holdsStew = true },
			t_rga_porcelainbowl_02 = { capacity = 60, holdsStew = true },
			t_rga_porcelainbowl_03 = { capacity = 60, holdsStew = true },
			t_rga_porcelaincup_01 = { capacity = 25 },
			t_rga_porcelainflask_01 = {  capacity = 80 },
			t_rga_porcelainpitcher_01 = { capacity = 190 },
			t_rga_porcelainpitcher_02 = { capacity = 190 },
			t_rga_porcelainvase_01 = { capacity = 200 },
			t_rga_porcelainvase_02 = { capacity = 200 },
			t_rga_porcelainvase_03 = { capacity = 200 },
			t_rga_redwarebowl_01 = { capacity = 60, holdsStew = true },
			t_rga_redwarecup_01 = { capacity = 25 },
			t_rga_redwarecup_02 = { capacity = 25 },
			t_rga_redwarecup_03 = { capacity = 25 },
			t_rga_redwaretagine_01 = {  holdsStew = true, capacity = 100 },
			t_rga_woodbowl_01 = { capacity = 60, holdsStew = true },
			t_rga_woodbowl_02 = { capacity = 60, holdsStew = true },
			t_rga_woodbowl_03 = { capacity = 60, holdsStew = true },
			t_rga_woodcup_01 = { capacity = 25 },
			t_rga_woodcup_02 = { capacity = 25 },
			t_rga_woodcup_03 = { capacity = 25 },
			t_rga_woodflask_01 = {  capacity = 80 },
			t_we_bonewarebottle_01 = { capacity = 90 },
			t_we_bonewarebowl_01 = { capacity = 60, holdsStew = true },
			t_we_bonewarecup_01 = { capacity = 25 },
			t_we_bonewareflask_01 = {  capacity = 80 },
			t_we_bonewaretankard_01 = {  capacity = 30 },
			t_yne_bottle_01a = { capacity = 90 },
			t_yne_bottle_01b = { capacity = 90 },
			t_yne_bottle_01c = { capacity = 90 },
			t_yne_bottle_01d = { capacity = 90 },
			t_yne_bottle_02a = { capacity = 90 },
			t_yne_bottle_02b = { capacity = 90 },
			t_yne_bottle_02c = { capacity = 90 },
			t_yne_bottle_02d = { capacity = 90 },
			t_yne_claybowl_01 = { capacity = 60, holdsStew = true },
			t_yne_claybowl_02 = { capacity = 60, holdsStew = true },
			t_yne_claybowl_03 = { capacity = 60, holdsStew = true },
			t_yne_claycup = { capacity = 25 },
			t_yne_claypitcher = { capacity = 190 },
			t_yne_clayvase_01 = { capacity = 200 },
			t_yne_clayvase_02 = { capacity = 200 },
			t_yne_clayvase_03 = { capacity = 200 },
			t_yne_clayvase_04 = { capacity = 200 },
			t_yne_stonebowl_01 = { capacity = 60, holdsStew = true },
			t_yne_stonebowl_02 = { capacity = 60, holdsStew = true },
			t_yne_stonebowl_03 = { capacity = 60, holdsStew = true },
			t_yne_stonecup = { capacity = 25 },
			t_yne_stonepitcher = { capacity = 190 },
			t_yne_stonevase_01 = { capacity = 200 },
			t_yne_stonevase_02 = { capacity = 200 },
			t_yne_woodenbowl_01 = { capacity = 60, holdsStew = true },
			t_yne_woodenbowl_02 = { capacity = 60, holdsStew = true },
			t_yne_woodenbowl_03 = { capacity = 60, holdsStew = true },
			t_yne_woodencup_01 = { capacity = 25 },
			t_yne_woodenpitcher_01 = { capacity = 190 },
			t_yne_woodenpot_01 = {  holdsStew = true, capacity = 100 },
			
			t_arg_woodenkettle_01 = { type = "kettle", capacity = 100 },
			t_bre_pewterkettle_01 = { type = "kettle", capacity = 100 },
			--t_bre_pewterpan_01 = { type = "grill", fryingPan = true },
			t_bre_pewterteapot_01 = { type = "kettle", capacity = 100 },
			t_bre_stonewareteapot_01 = { type = "kettle", capacity = 100 },
			t_com_copperkettle_01 = { type = "kettle", capacity = 100 },
			--t_com_copperpan_01 = { type = "grill", fryingPan = true },
			t_com_copperpot_01 = { type = "cookingPot", capacity = 200, holdsStew = true },
			t_com_coppetteapot_01 = { type = "kettle", capacity = 100 },
			t_com_ironpot_01 = { type = "cookingPot", capacity = 200, holdsStew = true },
			t_com_ironpot_02 = { type = "cookingPot", capacity = 200, holdsStew = true },
			t_com_ironpot_03 = { type = "cookingPot", capacity = 200, holdsStew = true },
			--t_de_pan_01 = { type = "grill", fryingPan = true },
			t_de_punavitkettle_01 = { type = "kettle", capacity = 100 },
			t_he_blueceladonteapot_01 = { type = "kettle", capacity = 100 },
			t_he_greenceladonteapot_01 = { type = "kettle", capacity = 100 },
			t_yne_clayteapot = { type = "kettle", capacity = 100 },
			t_yne_stoneteapot = { type = "kettle", capacity = 100 },
			t_yne_woodenteapot_01 = { type = "kettle", capacity = 100 },
		}

		ashfall.registerWoodAxes{
			
		}

		ashfall.registerHeatSources{
			
		}

		local utensils = {
			t_arg_woodenkettle_01 = { type = "kettle", capacity = 100 },
			-- t_arg_woodenladle_01 = { type = "ladles" },
			t_bre_pewterkettle_01 = { type = "kettle", capacity = 100 },
			t_bre_pewterpan_01 = { type = "grill", fryingPan = true },
			t_bre_pewterteapot_01 = { type = "kettle", capacity = 100 },
			t_bre_stonewareteapot_01 = { type = "kettle", capacity = 100 },
			t_com_copperkettle_01 = { type = "kettle", capacity = 100 },
			t_com_copperpan_01 = { type = "grill", fryingPan = true },
			t_com_copperpot_01 = { type = "cookingPot", capacity = 200, holdsStew = true },
			t_com_coppetteapot_01 = { type = "kettle", capacity = 100 },
			-- t_com_flintandsteel_01 = { type = "firestarters" }, --not working
			t_com_ironpot_01 = { type = "cookingPot", capacity = 200, holdsStew = true },
			t_com_ironpot_02 = { type = "cookingPot", capacity = 200, holdsStew = true },
			t_com_ironpot_03 = { type = "cookingPot", capacity = 200, holdsStew = true },
			t_de_pan_01 = { type = "grill", fryingPan = true },
			t_de_punavitkettle_01 = { type = "kettle", capacity = 100 },
			t_he_blueceladonteapot_01 = { type = "kettle", capacity = 100 },
			t_he_greenceladonteapot_01 = { type = "kettle", capacity = 100 },
			-- t_qy_bronzeladel = { type = "ladles" },
			-- t_yne_clayladel = { type = "ladles" },
			t_yne_clayteapot = { type = "kettle", capacity = 100 },
			-- t_yne_stoneladle = { type = "ladles" },
			t_yne_stoneteapot = { type = "kettle", capacity = 100 },
			-- t_yne_woodenladle_01 = { type = "ladles" },
			t_yne_woodenteapot_01 = { type = "kettle", capacity = 100 },
		}
		
		for _, data in ipairs(utensils) do
			ashfall.registerUtensil(data)
		end
		-- for _, data in ipairs(utensils) do
			-- ashfall.registerWaterContainers(data)
		-- end

		ashfall.registerTeas{

		}

		ashfall.registerClimates{
			-- Oceans
			["padomaic ocean region"]  = types.mild,
			["sea of ghosts region"]   = types.cold,
			["sea of ghosts region n"] = types.polar,
			["abecean sea region"]     = types.tropical,

			-- Morrowind
			["aranyon pass region"]      = types.cold,
			["dagon urul region"]        = types.cold,
			["julan-shar region"]        = types.cold,
			["telvanni isles region"]    = types.cold,
			["velothi mountains region"] = types.cold,
			["shipal-shin region"]       = types.dry,
			["alt orethan region"]       = types.mild,
			["boethiah's spine region"]  = types.mild,
			["clambering moor region"]   = types.mild,
			["grey meadows region"]      = types.mild,
			["helnim fields region"]     = types.mild,
			["mephalan vales region"]    = types.mild,
			["molag ruhn region"]        = types.mild,
			["molagreahd region"]        = types.mild,
			["nedothril region"]         = types.mild,
			["roth roryn region"]        = types.mild,
			["sacred lands region"]      = types.mild,
			["uld vraech region"]        = types.polar,
			["aanthirin region"]         = types.temperate,
			["ascadian bluffs region"]   = types.temperate,
			["deshaan plains region"]    = types.temperate,
			["lan orethan region"]       = types.temperate,
			["mudflats region"]          = types.temperate,
			["old ebonheart region"]     = types.temperate,
			["othreleth woods region"]   = types.temperate,
			["salt marsh region"]        = types.temperate,
			["thirr valley region"]      = types.temperate,
			["arnesian jungle region"]   = types.tropical,
			["armun ashlands region"]    = types.volcanic,
			["sundered scar region"]     = types.volcanic,
		
			-- Skyrim
			["drajkmyr marsh region"]          = types.cold,
			["druadach highlands region"]      = types.cold,
			["hirsing forest region"]          = types.cold,
			["hrimbald plateau region"]        = types.cold,
			["mhorkren hills region"]          = types.cold,
			["midkarth region"]                = types.cold,
			["solitude forest region s"]       = types.cold,
			["sundered hills region"]          = types.cold,
			["troll's teeth mountains region"] = types.cold,
			["valstaag highlands region"]      = types.cold,
			["vorndgad forest region"]         = types.cold,
			["white plains region"]            = types.cold,
			["kreathi vale region"]            = types.mild,
			["lorchwuir hearth region"]        = types.mild,
			["rift valley region"]             = types.mild,
			["falkheim region"]                = types.polar,
			["gorvigh mountains region"]       = types.polar,
			["kilkreath mountains region"]     = types.polar,
			["northshore region"]              = types.polar,
			["reaver's shore region"]          = types.polar,
			["skaldring mountains region"]     = types.polar,
			["solitude forest region"]         = types.polar,
			["throat of the world region"]     = types.polar,
			["wuurthal dale region"]           = types.polar,
			["ysheim region"]                  = types.polar,

			-- Cyrodiil
			["colovian barrowlands region"] = types.cold,
			["jerall mountains region"]     = types.cold,
			["colovian highlands region"]   = types.dry,
			["gilded hills region"]         = types.dry,
			["gold coast region"]           = types.tropical,
			["kvetchi pass region"]         = types.temperate,
			["west weald region"]           = types.temperate,
			["dasek marsh region"]          = types.tropical,
			["stirk isle region"]           = types.tropical,

			-- High Rock
			["dragonfields region"] = types.cold,
		}

		-- ashfall.getFirewoodIds{
			-- T_Com_Scrapwood01,
			-- T_Com_Scrapwood02,
			-- T_Com_Scrapwood03,
			-- T_Com_Scrapwood04,
			-- T_Com_Scrapwood05,
		-- }
		
	end
end)